/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.command;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.Log4jConfigurationExtension;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.utils.UiUtils;

public class CreateLog4jConfigurationFiles
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMuleProject muleProject = UiUtils.getSelectedMuleProjectInPackageExplorer();
        if (muleProject != null) {
            try {
                this.doRun(muleProject);
            }
            catch (IOException | CoreException e) {
                MuleUIPlugin.getDefault().logError("There was an error generating log4j configuration files for project " + muleProject.getName(), e);
            }
        }
        return null;
    }

    private void doRun(IMuleProject muleProject) throws CoreException, IOException {
        Optional log4jConfigurationExtension = Log4jConfigurationExtension.getLog4jConfiguration((IServerDefinition)muleProject.getServerDefinition());
        if (log4jConfigurationExtension.isPresent()) {
            IMuleApplicationProject applicationProject;
            IFile testFile;
            Log4jConfigurationExtension log4jConfiguration = (Log4jConfigurationExtension)log4jConfigurationExtension.get();
            IFile file = muleProject.getMuleResourcesFolder().getFile(log4jConfiguration.getMainFileName());
            if (this.shouldWrite(file)) {
                this.writeFile(file, log4jConfiguration.getMainFile(), muleProject);
            }
            if (MuleProjectKind.APPLICATION.classifies(muleProject) && this.shouldWrite(testFile = (applicationProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject)).getMuleTestResourcesFolder().getFile(log4jConfiguration.getTestFileName()))) {
                this.writeFile(testFile, log4jConfiguration.getTestFile(), muleProject);
            }
        }
    }

    public boolean shouldWrite(IFile file) {
        return !file.exists() || file.exists() && this.override(file);
    }

    public void writeFile(IFile file, URL mainFile, IMuleProject muleProject) throws CoreException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(mainFile.openStream());){
            String contents = IOUtils.toString((Reader)reader);
            String replacedContents = contents.replaceAll("APPLICATIONNAME", muleProject.getName());
            ByteArrayInputStream stream = new ByteArrayInputStream(replacedContents.getBytes());
            if (!file.exists()) {
                file.create((InputStream)stream, true, null);
            } else {
                file.setContents((InputStream)stream, true, true, null);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean override(IFile file) {
        return MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Create Log4j Configuration", (String)("A Log4j configuration file already exists at " + String.valueOf(file.getFullPath()) + ".\nDo you want to overwrite it with default contents?"));
    }
}

