/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.command;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.impl.model.DefaultInitializationData;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;

public class ConvertToMuleProject
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean transform;
        IProject selectedProject;
        Object selected;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null & selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof IJavaElement && (selectedProject = ((IJavaElement)selected).getJavaProject().getProject()) != null && (transform = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Java project to Anypoint Studio project", (String)"Do you want to transform this Java project to a Anypoint Studio Project? This action is not undoable."))) {
            WorkspaceJob changeClasspathJob = new WorkspaceJob("Converting project..."){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask("Converting project...", 100);
                    try {
                        try {
                            MuleRuntime.addMuleNature((IProject)selectedProject);
                            monitor.worked(25);
                            String runtimeId = CoreUtils.getDefaultServerRuntimeId();
                            IMuleProject muleProject = MuleRuntime.createMuleProject((IJavaProject)JavaCore.create((IProject)selectedProject), (ProjectInitializationData)DefaultInitializationData.create().setName(selectedProject.getName()).setDescription("").setRuntimeId(runtimeId));
                            muleProject.save();
                            MuleRuntime.configureMuleProjectClasspath((IMuleProject)muleProject, (IServerDefinition)CoreUtils.getDefaultServer());
                            monitor.worked(50);
                        }
                        catch (CoreException coreException) {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error while converting project", (String)"There was an error while converting the project to a Anypoint Studio Project.");
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            changeClasspathJob.setUser(true);
            changeClasspathJob.setPriority(20);
            changeClasspathJob.schedule();
        }
        return null;
    }
}

