/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.command;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.command.ChangeThemeWarning;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class ChangeTheme
extends AbstractHandler
implements IElementUpdater {
    private static ImageDescriptor image_moon = MuleImages.getManaged("", "moon.png");
    private static ImageDescriptor image_sun = MuleImages.getManaged("", "sun.png");
    private static boolean popupOpened = false;

    public Object execute() {
        return this.execute(new ExecutionEvent());
    }

    public Object execute(ExecutionEvent event) {
        if (ThemeUtils.getCurrentThemeId().equals("org.mule.tooling.ui.theme.light")) {
            ThemeUtils.setCurrentTheme((String)"org.mule.tooling.ui.theme.dark");
            AnalyticsRecordsFactory.single((String)Events.CHANGE_THEME_BUTTON_PRESSED, (String[])new String[]{"themeName", "Studio Dark Theme"}).track();
        } else {
            ThemeUtils.setCurrentTheme((String)"org.mule.tooling.ui.theme.light");
            AnalyticsRecordsFactory.single((String)Events.CHANGE_THEME_BUTTON_PRESSED, (String[])new String[]{"themeName", "Studio Light Theme"}).track();
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements("org.mule.tooling.ui.command.changeTheme", null);
        }
        ChangeTheme.showChangeThemeNotification();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        if (ThemeUtils.getCurrentThemeId().equals("org.mule.tooling.ui.theme.light")) {
            element.setIcon(image_moon);
            element.setTooltip("Switch to Dark Theme");
        } else {
            element.setIcon(image_sun);
            element.setTooltip("Switch to Light Theme");
        }
    }

    private static void showChangeThemeNotification() {
        if (!popupOpened) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(() -> {
                ChangeThemeWarning changeThemeWarning = new ChangeThemeWarning();
                changeThemeWarning.open();
                changeThemeWarning.getShell().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        popupOpened = false;
                    }
                });
                popupOpened = true;
            });
        }
    }
}

