/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewRegistry;
import org.mule.tooling.ui.IStudioPerspective;

public class StudioPerspective
implements IPerspectiveFactory,
IStudioPerspective {
    protected static final String PALETTE_VIEW_ID = "org.mule.tooling.ui.palette.PaletteView";
    protected static final String APIKIT_CONSOLES_VIEW_ID = "org.mule.tooling.apikit.common.views.APIkitConsolesView";
    private static final String MULE_TOOLING_WIZARD_ID = "org.mule.tooling.ui.muleToolingWizard";
    private static final String NEW_API_PROJECT_WIZARD_ID = "org.mule.tooling.apidesigner.newApiProject";
    private static final String TEMPLATES_REPO_WIZARD_ID = "org.mule.tooling.templatesrepo.templatesRepoWizard";
    private static final String DATAMAPPER_VIEW_ID = "org.mule.tooling.datamapper.ui.view.dataMapperView";
    private static final String MAPPING_FLOW_WIZARD_ID = "org.mule.tooling.datamapper.mappingFlowWizard";
    private static final String NEW_MULE_CONFIGURATION_FILE_WIZARD_ID = "org.mule.tooling.ui.messageFlowWizard";
    private static final String NEW_API_SPECIFICATION_FILE_WIZARD_ID = "org.mule.alsp.wizard.apis.specification";
    private static final String NEW_API_FRAGMENT_FILE_WIZARD_ID = "org.mule.alsp.wizard.apis.fragment";

    public void createInitialLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        this.generateFolderLayout(layout, editorArea);
        this.generateLeftBottomSection(layout);
        this.generateBottomSection(layout, editorArea);
        this.generateRightSection(layout, editorArea);
        this.addActionSets(layout);
        this.addShowViewShortcuts(layout);
        this.addNewWizardShortcuts(layout);
    }

    @Override
    public void generateFolderLayout(IPageLayout layout, String editorArea) {
        IFolderLayout folder = layout.createFolder("left", 1, 0.2f, editorArea);
        folder.addView("org.eclipse.jdt.ui.PackageExplorer");
        folder.addPlaceholder("org.eclipse.ui.navigator.ProjectExplorer");
    }

    @Override
    public void generateLeftBottomSection(IPageLayout layout) {
        IFolderLayout leftBottom = layout.createFolder("leftBottom", 4, 0.55f, "left");
        leftBottom.addView("org.eclipse.ui.views.ContentOutline");
        leftBottom.addPlaceholder(APIKIT_CONSOLES_VIEW_ID);
    }

    @Override
    public void generateBottomSection(IPageLayout layout, String editorArea) {
    }

    @Override
    public void generateRightSection(IPageLayout layout, String editorArea) {
    }

    @Override
    public void addActionSets(IPageLayout layout) {
        layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        layout.addActionSet("org.eclipse.jdt.ui.JavaActionSet");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
    }

    @Override
    public void addShowViewShortcuts(IPageLayout layout) {
        layout.addShowViewShortcut("org.eclipse.jdt.ui.PackageExplorer");
        layout.addShowViewShortcut("org.eclipse.search.ui.views.SearchView");
        layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProgressView");
        layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
        layout.addShowViewShortcut(PALETTE_VIEW_ID);
    }

    @Override
    public void addNewWizardShortcuts(IPageLayout layout) {
        layout.addNewWizardShortcut(MULE_TOOLING_WIZARD_ID);
        layout.addNewWizardShortcut(NEW_API_PROJECT_WIZARD_ID);
        layout.addNewWizardShortcut(TEMPLATES_REPO_WIZARD_ID);
        layout.addNewWizardShortcut(NEW_MULE_CONFIGURATION_FILE_WIZARD_ID);
        layout.addNewWizardShortcut(NEW_API_SPECIFICATION_FILE_WIZARD_ID);
        layout.addNewWizardShortcut(NEW_API_FRAGMENT_FILE_WIZARD_ID);
    }

    @Override
    public void addBottomSectionPlaceholders(IFolderLayout outputfolder) {
        outputfolder.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        outputfolder.addPlaceholder("org.eclipse.ui.console.ConsoleView");
        outputfolder.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        outputfolder.addPlaceholder("org.eclipse.ui.views.ProgressView");
    }

    public void initDataMapperViews(IPageLayout layout, IFolderLayout outputfolder) {
        boolean isDataMapperInstalled;
        IViewRegistry viewRegistry = PlatformUI.getWorkbench().getViewRegistry();
        boolean bl = isDataMapperInstalled = viewRegistry.find(DATAMAPPER_VIEW_ID) != null;
        if (isDataMapperInstalled) {
            outputfolder.addView(DATAMAPPER_VIEW_ID);
            layout.addNewWizardShortcut(MAPPING_FLOW_WIZARD_ID);
        }
    }
}

