/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.mule.tooling.ui.preferences.extension.PreferenceContributionProvider;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.osgi.framework.Bundle;

@ExtensionPoint(extensionPointId="org.mule.tooling.ui.preferencecontribution")
public class PreferenceContributionExtension
implements Comparable<PreferenceContributionExtension> {
    @Inject
    private Bundle bundle;
    @ExtensionAttribute
    private String id;
    @ExtensionAttribute
    private String contributedPageId;
    @ExtensionAttribute
    private PreferenceContributionProvider provider;
    @ExtensionAttribute
    private int weight;

    public static List<PreferenceContributionExtension> findAll(final String preferencePageId) {
        return FluentIterable.from(Singleton.preferenceContributionExtensions).filter((Predicate)new Predicate<PreferenceContributionExtension>(){

            public boolean apply(PreferenceContributionExtension extension) {
                return extension.contributedPageId.equals(preferencePageId);
            }
        }).toList();
    }

    private static List<PreferenceContributionExtension> getPreferenceContributionExtensions() {
        List allContributions = IExtensionPointReader.create(PreferenceContributionExtension.class).readAll();
        Collections.sort(allContributions);
        return allContributions;
    }

    @Override
    public int compareTo(PreferenceContributionExtension that) {
        return this.weight - that.weight;
    }

    public IPreferenceStore getPreferenceStore() {
        String symbolicName = this.bundle.getSymbolicName();
        if (symbolicName == null) {
            throw new RuntimeException("The plugin for contribution " + this.id + " has no symbolic name");
        }
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, symbolicName);
    }

    public PreferenceContributionProvider getProvider() {
        return this.provider;
    }

    public String toString() {
        return MessageFormat.format("PreferenceContributionExtension [id={0}, contributedPageId={1}, provider.class={2}, weight={3}]", this.id, this.contributedPageId, this.provider.getClass().getName(), this.weight);
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setProvider(PreferenceContributionProvider provider) {
        this.provider = provider;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setContributedPageId(String contributedPageId) {
        this.contributedPageId = contributedPageId;
    }

    private static class Singleton {
        private static final List<PreferenceContributionExtension> preferenceContributionExtensions = PreferenceContributionExtension.getPreferenceContributionExtensions();

        private Singleton() {
        }
    }
}

