/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.ui.ResetMulePerspectiveJob;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class MuleUIPlugin
extends AbstractUIPlugin {
    static final String TOOLING_PERSPECTIVE_ID = "org.mule.tooling.ui.toolingPerspective";
    public static final String DEBUG_PERSPECTIVE_ID = "org.mule.tooling.ui.debugPerspective";
    public static final String PLUGIN_ID = "org.mule.tooling.ui";
    private static final String PREFERENCES_CURRENT_UI_PLUGIN_VERSION = "tooling_ui_preference_current_ui_plugin_version";
    private static MuleUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.scheduleResetPerspectiveOnUpdateJob();
    }

    private void scheduleResetPerspectiveOnUpdateJob() {
        IPreferenceStore store = this.getPreferenceStore();
        String storedUiPluginVersion = store.getString(PREFERENCES_CURRENT_UI_PLUGIN_VERSION);
        Version storedVersion = Version.parseVersion((String)storedUiPluginVersion);
        Version currentVersion = this.getBundle().getVersion();
        if (currentVersion.compareTo(storedVersion) != 0) {
            ResetMulePerspectiveJob resetPerspectiveJob = new ResetMulePerspectiveJob("Reset perspective on update");
            resetPerspectiveJob.schedule();
            store.setValue(PREFERENCES_CURRENT_UI_PLUGIN_VERSION, currentVersion.toString());
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static MuleUIPlugin getDefault() {
        return plugin;
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, error, throwable));
    }

    public static IStatus createStatus(int type, String message) {
        return new Status(type, PLUGIN_ID, message);
    }

    public static void openError(Shell shell, Exception e) {
        MuleUIPlugin.openError(shell, MuleUIPlugin.createStatus(4, e.getMessage()));
    }

    public static void openError(Shell shell, IStatus e) {
        ErrorDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage(), (IStatus)e);
    }
}

