/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.MessageDialogWithLink;

public class MessageDialogUtils {
    private static final String ECLIPSE_LOG_VIEW_ID = "org.eclipse.pde.runtime.LogView";

    private MessageDialogUtils() {
        throw new IllegalStateException("Not intended to be instanciated");
    }

    public static void openErrorWithLinkToLogView(Shell parentShell, String title, String errorMessage) {
        StringBuilder message = new StringBuilder(errorMessage);
        message.append(System.lineSeparator());
        message.append("Check the <a>Error Log</a> for further details.");
        MessageDialogWithLink messageDialogWithLink = new MessageDialogWithLink(parentShell, title, null, message.toString(), 1, 0, IDialogConstants.OK_LABEL);
        messageDialogWithLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ECLIPSE_LOG_VIEW_ID);
            }
            catch (PartInitException ex) {
                MuleCorePlugin.logError((String)"Could not initialize ErrorLog view", (Throwable)ex);
                ex.printStackTrace();
            }
        }));
        messageDialogWithLink.open();
    }
}

