/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.mule.runtime.dsl.internal.xml.parser.XmlCustomAttributeHandler;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotations;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlApplicationParser {
    private final org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser parser;

    public XmlApplicationParser(List<XmlNamespaceInfoProvider> namespaceInfoProviders) {
        this.parser = new org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser(namespaceInfoProviders);
    }

    @Deprecated
    public Optional<ConfigLine> parse(Element configElement) {
        return this.configLineFromElement(configElement);
    }

    @Deprecated
    private Optional<ConfigLine> configLineFromElement(Node node) {
        if (!this.isValidType(node)) {
            return Optional.empty();
        }
        String identifier = this.parseIdentifier(node);
        String namespace = this.parseNamespace(node);
        String namespaceUri = this.parseNamespaceUri(node);
        ConfigLine.Builder builder = new ConfigLine.Builder().setIdentifier(identifier).setNamespace(namespace).setNamespaceUri(namespaceUri);
        XmlMetadataAnnotations userData = (XmlMetadataAnnotations)node.getUserData("metadataAnnotations");
        builder.setLineNumber(userData.getOpeningTagBoundaries().getStartLineNumber()).setStartColumn(userData.getOpeningTagBoundaries().getStartColumnNumber()).setSourceCode(userData.getElementString());
        XmlCustomAttributeHandler.to(builder).addCustomAttributes(node);
        Element element = (Element)node;
        NamedNodeMap attributes = element.getAttributes();
        if (element.hasAttributes()) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                Attr attributeNode = element.getAttributeNode(attribute.getNodeName());
                boolean isFromXsd = !attributeNode.getSpecified();
                builder.addConfigAttribute(attribute.getNodeName(), attribute.getNodeValue(), isFromXsd);
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (this.isTextContent(child)) {
                    builder.setTextContent(child.getNodeValue());
                    if (child.getNodeType() != 4) continue;
                    builder.addCustomAttribute("IS_CDATA", Boolean.TRUE);
                    break;
                }
                this.configLineFromElement(child).ifPresent(builder::addChild);
            }
        }
        return Optional.of(builder.build());
    }

    public String parseNamespace(Node node) {
        return this.parser.parseNamespace(node);
    }

    public String parseNamespaceUri(Node node) {
        return this.parser.parseNamespaceUri(node);
    }

    public String parseIdentifier(Node node) {
        return this.parser.parseIdentifier(node);
    }

    private boolean isValidType(Node node) {
        return this.parser.isValidType(node);
    }

    public boolean isTextContent(Node node) {
        return org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser.isTextContent(node);
    }
}

