/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.DslSimpleType;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class ComponentBuildingDefinition<T> {
    public static final String TYPE_CONVERTER_AND_UNKNOWN_TYPE_MESSAGE = "Type converter cannot be used with a type definition from a configuration attribute.";
    public static final String TYPE_CONVERTER_AND_NO_SIMPLE_TYPE_MESSAGE_TEMPLATE = "Type converter can only be used with simple types. You can't use it with %s";
    public static final String KEY_TYPE_CONVERTER_AND_NO_MAP_TYPE = "key type converter can only be used with objects of type Map";
    private TypeDefinition typeDefinition;
    private boolean scope;
    private List<AttributeDefinition> constructorAttributeDefinition = new ArrayList<AttributeDefinition>();
    private List<SetterAttributeDefinition> setterParameterDefinitions = new ArrayList<SetterAttributeDefinition>();
    private final Set<String> ignoredConfigurationParameters = new HashSet<String>();
    private Class<? extends ObjectFactory<T>> objectFactoryType;
    private boolean prototype;
    private boolean named = false;
    private ComponentIdentifier componentIdentifier;
    private Optional<TypeConverter> typeConverter = Optional.empty();
    private Optional<TypeConverter> keyTypeConverter = Optional.empty();
    private boolean alwaysEnabled = false;
    private String registrationName;

    private ComponentBuildingDefinition() {
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public boolean isScope() {
        return this.scope;
    }

    public List<AttributeDefinition> getConstructorAttributeDefinition() {
        return this.constructorAttributeDefinition;
    }

    public List<SetterAttributeDefinition> getSetterParameterDefinitions() {
        return this.setterParameterDefinitions;
    }

    public Set<String> getIgnoredConfigurationParameters() {
        return Collections.unmodifiableSet(new LinkedHashSet<String>(this.ignoredConfigurationParameters));
    }

    public Class<? extends ObjectFactory<T>> getObjectFactoryType() {
        return this.objectFactoryType;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public Optional<TypeConverter> getTypeConverter() {
        return this.typeConverter;
    }

    public Optional<TypeConverter> getKeyTypeConverter() {
        return this.keyTypeConverter;
    }

    @Deprecated
    public boolean isAlwaysEnabled() {
        return this.alwaysEnabled;
    }

    public boolean isNamed() {
        return this.named;
    }

    public String getRegistrationName() {
        return this.registrationName;
    }

    public List<AttributeDefinition> getAttributesDefinitions() {
        return Stream.concat(this.setterParameterDefinitions.stream().map(SetterAttributeDefinition::getAttributeDefinition), this.constructorAttributeDefinition.stream()).collect(Collectors.toList());
    }

    public static class Builder<T> {
        private String namespace;
        private String identifier;
        private final ComponentBuildingDefinition<T> definition = new ComponentBuildingDefinition();

        public Builder<T> withConstructorParameterDefinition(AttributeDefinition attributeDefinition) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).constructorAttributeDefinition.add(attributeDefinition);
            return next;
        }

        public Builder<T> withSetterParameterDefinition(String fieldName, AttributeDefinition attributeDefinition) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).setterParameterDefinitions.add(new SetterAttributeDefinition(fieldName, attributeDefinition));
            return next;
        }

        public Builder<T> withIdentifier(String identifier) {
            Builder<T> next = this.copy();
            next.identifier = identifier;
            return next;
        }

        public Builder<T> withNamespace(String namespace) {
            Builder<T> next = this.copy();
            next.namespace = namespace;
            return next;
        }

        public Builder<T> withTypeDefinition(TypeDefinition<T> typeDefinition) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).typeDefinition = typeDefinition;
            return next;
        }

        public Builder<T> withTypeConverter(TypeConverter typeConverter) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).typeConverter = Optional.of(typeConverter);
            return next;
        }

        public Builder<T> withKeyTypeConverter(TypeConverter typeConverter) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).keyTypeConverter = Optional.of(typeConverter);
            return next;
        }

        @Deprecated
        public Builder<T> alwaysEnabled(boolean value) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).alwaysEnabled = value;
            return next;
        }

        public Builder<T> withRegistrationName(String name) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).registrationName = name;
            return next;
        }

        public Builder<T> asScope() {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).scope = true;
            return next;
        }

        public Builder<T> asNamed() {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).named = true;
            return next;
        }

        public Builder<T> withObjectFactoryType(Class<? extends ObjectFactory<T>> objectFactoryType) {
            if (Initialisable.class.isAssignableFrom(objectFactoryType) || Startable.class.isAssignableFrom(objectFactoryType) || Stoppable.class.isAssignableFrom(objectFactoryType) || Disposable.class.isAssignableFrom(objectFactoryType)) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Class %s is an ObjectFactory so it cannot implement lifecycle methods", objectFactoryType.getCanonicalName())));
            }
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).objectFactoryType = objectFactoryType;
            return next;
        }

        public Builder<T> withIgnoredConfigurationParameter(String parameterName) {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).ignoredConfigurationParameters.add(parameterName);
            return next;
        }

        private Builder<T> copy() {
            Builder<T> builder = new Builder<T>();
            ((ComponentBuildingDefinition)builder.definition).typeDefinition = ((ComponentBuildingDefinition)this.definition).typeDefinition;
            ((ComponentBuildingDefinition)builder.definition).setterParameterDefinitions = new ArrayList(((ComponentBuildingDefinition)this.definition).setterParameterDefinitions);
            ((ComponentBuildingDefinition)builder.definition).constructorAttributeDefinition = new ArrayList(((ComponentBuildingDefinition)this.definition).constructorAttributeDefinition);
            builder.identifier = this.identifier;
            builder.namespace = this.namespace;
            ((ComponentBuildingDefinition)builder.definition).prototype = ((ComponentBuildingDefinition)this.definition).prototype;
            ((ComponentBuildingDefinition)builder.definition).scope = ((ComponentBuildingDefinition)this.definition).scope;
            ((ComponentBuildingDefinition)builder.definition).typeDefinition = ((ComponentBuildingDefinition)this.definition).typeDefinition;
            ((ComponentBuildingDefinition)builder.definition).objectFactoryType = ((ComponentBuildingDefinition)this.definition).objectFactoryType;
            ((ComponentBuildingDefinition)builder.definition).alwaysEnabled = ((ComponentBuildingDefinition)this.definition).alwaysEnabled;
            ((ComponentBuildingDefinition)builder.definition).registrationName = ((ComponentBuildingDefinition)this.definition).registrationName;
            if (this.definition.isNamed()) {
                ((ComponentBuildingDefinition)builder.definition).named = true;
            }
            return builder;
        }

        public ComponentBuildingDefinition<T> build() {
            Objects.requireNonNull(((ComponentBuildingDefinition)this.definition).typeDefinition, "You must specify the type");
            Objects.requireNonNull(this.identifier, "You must specify the identifier");
            Objects.requireNonNull(this.namespace, "You must specify the namespace");
            Optional<Class> componentType = this.getType();
            Preconditions.checkState((!((ComponentBuildingDefinition)this.definition).typeConverter.isPresent() || ((ComponentBuildingDefinition)this.definition).typeConverter.isPresent() && componentType.isPresent() ? 1 : 0) != 0, (String)ComponentBuildingDefinition.TYPE_CONVERTER_AND_UNKNOWN_TYPE_MESSAGE);
            Preconditions.checkState((!((ComponentBuildingDefinition)this.definition).typeConverter.isPresent() || ((ComponentBuildingDefinition)this.definition).typeConverter.isPresent() && (DslSimpleType.isSimpleType(componentType.get()) || this.isMapType(componentType.get())) ? 1 : 0) != 0, (String)String.format(ComponentBuildingDefinition.TYPE_CONVERTER_AND_NO_SIMPLE_TYPE_MESSAGE_TEMPLATE, componentType.orElse(Object.class).getName()));
            Preconditions.checkState((!((ComponentBuildingDefinition)this.definition).keyTypeConverter.isPresent() || ((ComponentBuildingDefinition)this.definition).keyTypeConverter.isPresent() && componentType.isPresent() && this.isMapType(componentType.get()) ? 1 : 0) != 0, (String)ComponentBuildingDefinition.KEY_TYPE_CONVERTER_AND_NO_MAP_TYPE);
            ((ComponentBuildingDefinition)this.definition).componentIdentifier = ComponentIdentifier.builder().name(this.identifier).namespace(this.namespace).build();
            return this.definition;
        }

        private boolean isMapType(Class componentType) {
            return Map.class.isAssignableFrom(componentType);
        }

        public Builder<T> asPrototype() {
            Builder<T> next = this.copy();
            ((ComponentBuildingDefinition)next.definition).prototype = true;
            return next;
        }

        private Optional<Class> getType() {
            final AtomicReference typeReference = new AtomicReference();
            ((ComponentBuildingDefinition)this.definition).typeDefinition.visit(new TypeDefinitionVisitor(){

                @Override
                public void onType(Class<?> type) {
                    typeReference.set(type);
                }

                @Override
                public void onConfigurationAttribute(String attributeName, Class<?> enforcedClass) {
                }

                @Override
                public void onConfigurationAttribute(String groupName, String attributeName, Class<?> enforcedClass) {
                }

                @Override
                public void onMapType(TypeDefinition.MapEntryType mapEntryType) {
                    typeReference.set(Map.class);
                }
            });
            return Optional.ofNullable((Class)typeReference.get());
        }
    }
}

