/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.manifest.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.mule.runtime.manifest.api.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleManifest
implements MuleManifest {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMuleManifest.class);
    private static final MuleManifest INSTANCE = new DefaultMuleManifest();
    private static Manifest manifest;
    private static volatile String productVersionFromProperties;

    private DefaultMuleManifest() {
    }

    public static MuleManifest get() {
        return INSTANCE;
    }

    @Override
    public String getProductVersion() {
        String version = DefaultMuleManifest.getManifestProperty("Implementation-Version");
        if (version == null) {
            return productVersionFromProperties;
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProductVersionFromPropertiesFile() {
        if (productVersionFromProperties == null) {
            DefaultMuleManifest defaultMuleManifest = this;
            synchronized (defaultMuleManifest) {
                if (productVersionFromProperties == null) {
                    String VERSION_PROPERTIES_PATH = "product-version/version.properties";
                    String WARNING_MESSAGE_VERSION_COULDNT_BE_RESOLVED = "Failure reading {} properties file to get productVersion";
                    String COULDNT_BE_RESOLVED_PLACEHOLDER = "<Mule version could not be resolved>";
                    Properties versionProps = new Properties();
                    try (InputStream versionPropsInputStream = MuleManifest.class.getClassLoader().getResourceAsStream("product-version/version.properties");){
                        if (versionPropsInputStream == null) {
                            logger.warn("Failure reading {} properties file to get productVersion", (Object)"product-version/version.properties");
                            productVersionFromProperties = "<Mule version could not be resolved>";
                        }
                        versionProps.load(versionPropsInputStream);
                        productVersionFromProperties = versionProps.getProperty("mule.version");
                    }
                    catch (IOException e) {
                        logger.warn("Failure reading {} properties file to get productVersion", (Object)"product-version/version.properties", (Object)e);
                        productVersionFromProperties = "<Mule version could not be resolved>";
                    }
                }
            }
        }
        return productVersionFromProperties;
    }

    @Override
    public String getVendorName() {
        return DefaultMuleManifest.getManifestProperty("Specification-Vendor");
    }

    @Override
    public String getVendorUrl() {
        return DefaultMuleManifest.getManifestProperty("Vendor-Url");
    }

    @Override
    public String getProductUrl() {
        return DefaultMuleManifest.getManifestProperty("Product-Url");
    }

    @Override
    public String getProductName() {
        return DefaultMuleManifest.getManifestProperty("Implementation-Title");
    }

    @Override
    public String getProductMoreInfo() {
        return DefaultMuleManifest.getManifestProperty("More-Info");
    }

    @Override
    public String getProductSupport() {
        return DefaultMuleManifest.getManifestProperty("Support");
    }

    @Override
    public String getProductLicenseInfo() {
        return DefaultMuleManifest.getManifestProperty("License");
    }

    @Override
    public String getProductDescription() {
        return DefaultMuleManifest.getManifestProperty("Description");
    }

    @Override
    public String getBuildNumber() {
        return DefaultMuleManifest.getManifestProperty("Build-Revision");
    }

    @Override
    public String getBuildDate() {
        return DefaultMuleManifest.getManifestProperty("Build-Date");
    }

    @Override
    public String getSupportedJdks() {
        return DefaultMuleManifest.getManifestProperty("Supported-Jdks");
    }

    @Override
    public String getRecommendedJdks() {
        return DefaultMuleManifest.getManifestProperty("Recommended-Jdks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Manifest getManifest() {
        block7: {
            if (manifest == null) {
                manifest = new Manifest();
                InputStream is = null;
                try {
                    URL url = AccessController.doPrivileged(new UrlPrivilegedAction());
                    if (url != null) {
                        URLConnection urlConnection = url.openConnection();
                        urlConnection.setUseCaches(false);
                        is = urlConnection.getInputStream();
                    }
                    if (is == null) break block7;
                    try {
                        manifest.read(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    logger.warn("Failed to read manifest Info, Manifest information will not display correctly: " + e.getMessage());
                }
            }
        }
        return manifest;
    }

    private static String getManifestProperty(String name) {
        return DefaultMuleManifest.get().getManifest().getMainAttributes().getValue(new Attributes.Name(name));
    }

    static class UrlPrivilegedAction
    implements PrivilegedAction<URL> {
        private static final Pattern EMBEDDED_JAR_PATTERN = Pattern.compile("mule[^-]*-[^-]*-embedded");
        private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

        UrlPrivilegedAction() {
        }

        @Override
        public URL run() {
            URL result = null;
            try {
                Enumeration<URL> e = MuleManifest.class.getClassLoader().getResources(MANIFEST_PATH);
                result = this.getManifestJarURL(e);
            }
            catch (IOException e1) {
                logger.warn("Failure reading manifest: " + e1.getMessage(), (Throwable)e1);
            }
            return result;
        }

        URL getManifestJarURL(Enumeration<URL> e) {
            TreeMap<String, URL> candidates = new TreeMap<String, URL>();
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if (!url.toExternalForm().contains("mule-manifest") && !url.toExternalForm().contains("mule-runtime-extension-model") && !url.toExternalForm().contains("mule-runtime-ee-extension-model") && (!EMBEDDED_JAR_PATTERN.matcher(url.toExternalForm()).find() || !url.toExternalForm().endsWith(".jar"))) continue;
                candidates.put(url.toExternalForm(), url);
            }
            if (!candidates.isEmpty()) {
                for (String candidateKey : candidates.keySet()) {
                    if (!candidateKey.contains("mule-manifest-ee") && !candidateKey.contains("mule-runtime-ee-extension-model")) continue;
                    return (URL)candidates.get(candidateKey);
                }
                return (URL)candidates.get(candidates.lastKey());
            }
            return null;
        }
    }
}

