/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.action;

import com.mulesoft.agent.domain.action.ServerAction;
import com.mulesoft.agent.domain.action.ServerActionStatus;
import com.mulesoft.agent.exception.RuntimeRestartException;
import com.mulesoft.agent.exception.RuntimeShutdownException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ActionService;
import com.mulesoft.agent.services.AdministrationService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.action.service")
@Singleton
public class MuleAgentActionService
implements ActionService {
    private static final Logger LOGGER = LogManager.getLogger(MuleAgentActionService.class);
    @Inject
    private List<InternalMessageHandler<ServerAction>> serverActionHandlers;
    @Inject
    private AdministrationService administrationService;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);

    public void performAction(ServerAction action) throws RuntimeRestartException, RuntimeShutdownException {
        LOGGER.debug("perform action: {}", (Object)action.getActionType());
        switch (action.getActionType()) {
            case RESTART: {
                this.administrationService.restartRuntime();
                break;
            }
            case SHUTDOWN: {
                this.administrationService.shutdownRuntime();
                break;
            }
            case RENEW_CERTIFICATE: {
                this.performRenewCertificateAction(action);
                break;
            }
        }
    }

    private void performRenewCertificateAction(ServerAction serverAction) {
        this.executorService.submit(() -> {
            try {
                this.administrationService.renewAgentCertificate();
                ServerAction action = new ServerAction();
                action.setId(serverAction.getId());
                action.setActionType(serverAction.getActionType());
                action.setStatus(ServerActionStatus.COMPLETED);
                action.setDescription("");
                action.setReason("");
                this.reportActionStatus(action);
            }
            catch (Exception e) {
                LOGGER.debug("Renew Certificate Error {} ", (Object)serverAction, (Object)e);
                ServerAction action = new ServerAction();
                action.setId(serverAction.getId());
                action.setActionType(serverAction.getActionType());
                action.setStatus(ServerActionStatus.FAILED);
                action.setDescription("");
                action.setReason("");
                this.reportActionStatus(action);
            }
        });
    }

    private void reportActionStatus(ServerAction serverAction) {
        LOGGER.trace("Reporting the server action {}. ", (Object)serverAction);
        for (InternalMessageHandler<ServerAction> handler : this.serverActionHandlers) {
            try {
                handler.handle((Object)serverAction);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to report the server action {}. Error was: {}.", (Object)serverAction, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        }
    }
}

