/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.rest.transport;

import com.google.common.base.Optional;
import com.google.gson.Gson;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.exception.AgentException;
import com.mulesoft.agent.exception.AgentInitializationException;
import com.mulesoft.agent.exception.AgentStartException;
import com.mulesoft.agent.exception.AgentStopException;
import com.mulesoft.agent.handlers.ExternalMessageHandler;
import com.mulesoft.agent.rest.AgentRestLayer;
import com.mulesoft.agent.rest.RestCertificate;
import com.mulesoft.agent.rest.transport.CallbackConfiguration;
import com.mulesoft.agent.rest.transport.RestSecurityConfiguration;
import com.mulesoft.agent.security.FipsUtils;
import com.mulesoft.agent.security.model.AgentSecurityProvider;
import com.mulesoft.agent.security.strategies.BouncyCastleCryptographyStrategy;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="rest.agent.transport")
@Singleton
public class RestAgentTransport
implements AgentTransport<Request, Response> {
    private static final Logger LOGGER = LogManager.getLogger(RestAgentTransport.class);
    private static final String TRUSTSTORE_FILE = "anypoint-truststore.jks";
    @Configurable(value="0.0.0.0")
    private String host;
    @Configurable(value="443")
    private int port;
    @Configurable
    private RestSecurityConfiguration restSecurity;
    @Configurable
    private CallbackConfiguration callback;
    private AgentRestLayer agentRestLayer;
    @Inject
    private Set<ExternalMessageHandler> handlers;
    @Configurable(value="true")
    private boolean enabled = true;
    private Gson gson = new Gson();

    public Optional<Response> send(Request message) throws IOException {
        if (this.callback != null && this.callback.getUrl() != null && this.isEnabled()) {
            message.setRootSource(this.callback.getUrl());
            if (this.callback.getHeaders() != null) {
                message.getHeaders().putAll(this.callback.getHeaders());
            }
            Optional response = Optional.of((Object)this.agentRestLayer.send(message));
            LOGGER.debug("Sending notification: " + message.getMethod() + " " + message.getResource());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Full notification:\n" + message.getMethod() + " " + message.getResource() + "\n" + this.gson.toJson(message.getBody(), message.getBody().getClass()));
            }
            return response;
        }
        return Optional.absent();
    }

    public void initialise() throws AgentInitializationException {
        try {
            this.initialiseSecurityProvider();
            if (this.restSecurity != null) {
                String configurationFolder = System.getProperty("mule.agent.configuration.folder");
                RestCertificate restCertificate = new RestCertificate(configurationFolder + File.separator + this.restSecurity.getKeyStoreFile(), this.restSecurity.getKeyStoreAlias());
                restCertificate.setTrustStore(this.buildTrustStoreFile());
                restCertificate.setKeyPassword(this.restSecurity.getKeyStoreAliasPassword());
                restCertificate.setKeyStorePassword(this.restSecurity.getKeyStorePassword());
                restCertificate.setTrustStorePassword(FipsUtils.getTrustStorePassword((String)this.restSecurity.getTrustStorePassword()));
                this.agentRestLayer = this.getAgentRestLayer(restCertificate);
            } else {
                this.agentRestLayer = this.getAgentRestLayer(null);
            }
            this.agentRestLayer.initialise(new ArrayList<ExternalMessageHandler>(this.handlers), true);
        }
        catch (KeyStoreException e) {
            throw new AgentInitializationException("Invalid keystore format. Your key store is not valid. Agent only support JKS keystore.", (Exception)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new AgentInitializationException("Error has occurred loading the keystore: The private key password provided is incorrect", (Exception)e);
        }
        catch (KeyManagementException e) {
            throw new AgentInitializationException("Error has occurred creating the SSL Context: Please verify the provided keystore(s)", (Exception)e);
        }
        catch (CertificateException e) {
            throw new AgentInitializationException("Invalid certificate algorithm. Your key store is not valid.", (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AgentInitializationException("Invalid keystore algorithm. Your key store is not valid.", (Exception)e);
        }
        catch (IOException e) {
            throw new AgentInitializationException("Unable to read keystore/truststore file for REST ssl connection", (Exception)e);
        }
    }

    public void initialiseSecurityProvider() {
        LOGGER.info("mule.security.provider: " + System.getProperty("mule.security.provider"));
        if (AgentSecurityProvider.BC.name().equals(System.getProperty("mule.security.provider"))) {
            BouncyCastleCryptographyStrategy.newInstance().loadSecurityProvider();
        }
    }

    protected AgentRestLayer getAgentRestLayer(RestCertificate restCertificate) {
        return new AgentRestLayer(this.host, this.port, restCertificate);
    }

    public void start() throws AgentStartException {
        try {
            this.agentRestLayer.start();
        }
        catch (Exception e) {
            String keyStoreInformation = this.restSecurity != null ? String.format("%s / %s", this.restSecurity.getKeyStoreAlias(), this.restSecurity.getKeyStoreFile()) : "not configured";
            String message = String.format("The REST Agent could not be started. Configuration (host: %s, port: %s, keyStore (alias / file): %s)", this.host, this.port, keyStoreInformation);
            throw new AgentStartException(message, e);
        }
    }

    public void enableIncomingRequests() throws AgentException {
        try {
            this.agentRestLayer.enable();
        }
        catch (Exception e) {
            String keyStoreInformation = this.restSecurity != null ? String.format("%s / %s", this.restSecurity.getKeyStoreAlias(), this.restSecurity.getKeyStoreFile()) : "not configured";
            String message = String.format("Unable to start REST http connector. Configuration (host: %s, port: %s, keyStore (alias / file): %s)", this.host, this.port, keyStoreInformation);
            throw new AgentException(message, e);
        }
    }

    public void stop() throws AgentStopException {
        try {
            this.agentRestLayer.stop();
        }
        catch (Exception e) {
            String keyStoreInformation = this.restSecurity != null ? String.format("%s / %s", this.restSecurity.getKeyStoreAlias(), this.restSecurity.getKeyStoreFile()) : "not configured";
            String message = String.format("Could not stop REST transport. Configuration (host: %s, port: %s, keyStore (alias / file): %s)", this.host, this.port, keyStoreInformation);
            throw new AgentStopException(message, e);
        }
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private Optional<File> buildTrustStoreFile() {
        Path path = Paths.get(this.restSecurity.getTrustStoreFile(), new String[0]);
        if (path.isAbsolute() && Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
            return Optional.of((Object)path.toFile());
        }
        if (path.getParent() != null) {
            LOGGER.error("Relative path in truststore file reference not supported.");
            return Optional.absent();
        }
        String configurationFolder = System.getProperty("mule.agent.configuration.folder");
        path = Paths.get(configurationFolder + File.separator + path.getFileName().toString(), new String[0]);
        if (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
            return Optional.of((Object)path.toFile());
        }
        LOGGER.info("Truststore file for Agent API REST: JVM");
        return Optional.absent();
    }
}

