/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.utils.Decoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogHeader {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogHeader.class);
    public static final int FORMAT_ID_HEADER = 0;
    public static final int TIMESTAMP_HEADER = 4;
    public static final int STATE_HEADER = 12;
    public static final int CURRENT_POSITION_HEADER = 13;
    public static final int HEADER_LENGTH = 21;
    public static final byte CLEAN_LOG_STATE = 0;
    public static final byte UNCLEAN_LOG_STATE = -1;
    private final FileChannel fc;
    private final long maxFileLength;
    private volatile int formatId;
    private volatile long timestamp;
    private volatile byte state;
    private volatile long position;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionLogHeader(FileChannel fc, long maxFileLength) throws IOException {
        this.fc = fc;
        this.maxFileLength = maxFileLength;
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            fc.position(0L);
            ByteBuffer buf = ByteBuffer.allocate(21);
            while (buf.hasRemaining()) {
                this.fc.read(buf);
            }
            buf.flip();
            this.formatId = buf.getInt();
            this.timestamp = buf.getLong();
            this.state = buf.get();
            this.position = buf.getLong();
            fc.position(this.position);
        }
        if (log.isDebugEnabled()) {
            log.debug("read header " + String.valueOf(this));
        }
    }

    public int getFormatId() {
        return this.formatId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte getState() {
        return this.state;
    }

    public long getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormatId(int formatId) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(formatId);
        buf.flip();
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            long currentPos = this.fc.position();
            this.fc.position(0L);
            while (buf.hasRemaining()) {
                this.fc.write(buf);
            }
            this.fc.position(currentPos);
            this.formatId = formatId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(long timestamp) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(this.position);
        buf.flip();
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            long currentPos = this.fc.position();
            this.fc.position(4L);
            while (buf.hasRemaining()) {
                this.fc.write(buf);
            }
            this.fc.position(currentPos);
            this.timestamp = timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(byte state) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put(state);
        buf.flip();
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            long currentPos = this.fc.position();
            this.fc.position(12L);
            while (buf.hasRemaining()) {
                this.fc.write(buf);
            }
            this.fc.position(currentPos);
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(long position) throws IOException {
        if (position < 21L) {
            throw new IOException("invalid position " + position + " (too low)");
        }
        if (position >= this.maxFileLength) {
            throw new IOException("invalid position " + position + " (too high)");
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(position);
        buf.flip();
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            this.fc.position(13L);
            while (buf.hasRemaining()) {
                this.fc.write(buf);
            }
            this.fc.position(position);
            this.position = position;
        }
    }

    public void goAhead(long distance) throws IOException {
        this.setPosition(this.getPosition() + distance);
    }

    public void rewind() throws IOException {
        this.setPosition(21L);
    }

    public String toString() {
        return "a Bitronix TransactionLogHeader with timestamp=" + this.timestamp + ", state=" + Decoder.decodeHeaderState(this.state) + ", position=" + this.position;
    }
}

