/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.logging;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.ConfigurationLevel;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.domain.logging.LogLevel;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.LoggingService;
import com.mulesoft.agent.services.logging.ArtifactLoggingConfiguration;
import com.mulesoft.agent.services.logging.ScopeLoggingConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.logging.service")
@Singleton
public class MuleAgentLoggingService
extends ConfigurableAgentService
implements LoggingService,
DeploymentServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(MuleAgentLoggingService.class);
    @Configurable(type=Type.DYNAMIC, value="[]", level=ConfigurationLevel.APPLICATION)
    private ArtifactLoggingConfiguration[] applicationLogLevels;
    @Configurable(type=Type.DYNAMIC, value="[]")
    private ArtifactLoggingConfiguration[] domainLogLevels;
    private Map<Artifact, List<String>> configuredScopes = new HashMap<Artifact, List<String>>();
    DeploymentService deploymentService;
    private DeploymentListener applicationDeploymentListener;
    private DeploymentListener domainDeploymentListener;

    protected void doStart() throws MuleException {
        this.applicationDeploymentListener = new LogApplicationDeploymentListener();
        this.domainDeploymentListener = new LogDomainDeploymentListener();
        this.deploymentService.addDeploymentListener(this.applicationDeploymentListener);
        this.deploymentService.addDomainDeploymentListener(this.domainDeploymentListener);
        for (Map.Entry<Artifact, List<String>> artifactConfiguration : this.configuredScopes.entrySet()) {
            for (String configuredScope : artifactConfiguration.getValue()) {
                this.clearArtifactLoggingLevel(artifactConfiguration.getKey(), configuredScope);
            }
        }
        this.configuredScopes.clear();
        this.domainLogLevels = this.domainLogLevels == null ? new ArtifactLoggingConfiguration[]{} : this.domainLogLevels;
        for (ArtifactLoggingConfiguration artifactLoggingConfiguration : Arrays.asList(this.domainLogLevels)) {
            this.setAllArtifactsLoggingLevelByDomain(artifactLoggingConfiguration);
        }
        this.applicationLogLevels = this.applicationLogLevels == null ? new ArtifactLoggingConfiguration[]{} : this.applicationLogLevels;
        for (ArtifactLoggingConfiguration artifactLoggingConfiguration : Arrays.asList(this.applicationLogLevels)) {
            this.setAllArtifactsLoggingLevelByApplication(artifactLoggingConfiguration);
        }
    }

    protected void doStop() throws MuleException {
        this.deploymentService.removeDeploymentListener(this.applicationDeploymentListener);
        this.deploymentService.removeDomainDeploymentListener(this.domainDeploymentListener);
    }

    public LogLevel getDomainLoggingLevel(String domainName, String scope) throws IllegalArgumentException, NoSuchElementException {
        if (domainName == null) {
            throw new IllegalArgumentException("Request needs to specify a valid domain name");
        }
        return this.getArtifactLoggingLevel((Artifact)this.deploymentService.findDomain(domainName), scope);
    }

    public void setDomainLoggingLevel(String domainName, String scope, LogLevel level) throws IllegalArgumentException, NoSuchElementException {
        if (domainName == null) {
            throw new IllegalArgumentException("Request needs to specify a valid domain name");
        }
        if (level == null) {
            throw new IllegalArgumentException("Request needs to specify a valid logging level");
        }
        this.setArtifactLoggingLevel((Artifact)this.deploymentService.findDomain(domainName), scope, level);
        if (!this.artifactIsTracked(this.domainLogLevels, domainName)) {
            this.domainLogLevels = (ArtifactLoggingConfiguration[])ArrayUtils.add((Object[])this.domainLogLevels, (Object)new ArtifactLoggingConfiguration(domainName));
        }
        this.setScopeLevel(this.domainLogLevels, domainName, scope, level);
    }

    public LogLevel getApplicationLoggingLevel(String applicationName, String scope) throws IllegalArgumentException, NoSuchElementException {
        if (applicationName == null) {
            throw new IllegalArgumentException("Request needs to specify a valid application name");
        }
        return this.getArtifactLoggingLevel((Artifact)this.deploymentService.findApplication(applicationName), scope);
    }

    public void setApplicationLoggingLevel(String applicationName, String scope, LogLevel level) throws IllegalArgumentException, NoSuchElementException {
        if (applicationName == null) {
            throw new IllegalArgumentException("Request needs to specify a valid application name");
        }
        if (level == null) {
            throw new IllegalArgumentException("Request needs to specify a valid logging level");
        }
        this.setArtifactLoggingLevel((Artifact)this.deploymentService.findApplication(applicationName), scope, level);
        if (!this.artifactIsTracked(this.applicationLogLevels, applicationName)) {
            this.applicationLogLevels = (ArtifactLoggingConfiguration[])ArrayUtils.add((Object[])this.applicationLogLevels, (Object)new ArtifactLoggingConfiguration(applicationName));
        }
        this.setScopeLevel(this.applicationLogLevels, applicationName, scope, level);
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new LinkedList<InternalMessageHandler>();
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    private boolean artifactIsTracked(ArtifactLoggingConfiguration[] artifactLoggingConfigurations, String artifactName) {
        for (ArtifactLoggingConfiguration artifactLoggingConfiguration : Arrays.asList(artifactLoggingConfigurations)) {
            if (!artifactName.equals(artifactLoggingConfiguration.getArtifactName())) continue;
            return true;
        }
        return false;
    }

    private void setScopeLevel(ArtifactLoggingConfiguration[] artifactLoggingConfigurations, String artifactName, String scope, LogLevel level) {
        for (ArtifactLoggingConfiguration artifactLoggingConfiguration : Arrays.asList(artifactLoggingConfigurations)) {
            if (!artifactName.equals(artifactLoggingConfiguration.getArtifactName())) continue;
            artifactLoggingConfiguration.addScopeLoggingConfiguration(new ScopeLoggingConfiguration(scope, level));
        }
    }

    private LogLevel getArtifactLoggingLevel(Artifact artifact, String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Request needs to specify a valid logging scope");
        }
        if (artifact == null) {
            throw new NoSuchElementException("Could not find artifact to get log level from");
        }
        ClassLoader appClassLoader = artifact.getArtifactClassLoader().getClassLoader();
        return (LogLevel)ClassUtils.withContextClassLoader((ClassLoader)appClassLoader, () -> {
            LoggerContext loggerContext = (LoggerContext)LogManager.getContext((ClassLoader)appClassLoader, (boolean)false);
            org.apache.logging.log4j.core.Logger logger = loggerContext.getLogger(scope);
            return LogLevel.valueOf((String)logger.getLevel().name());
        });
    }

    private void setArtifactLoggingLevel(Artifact artifact, String scope, LogLevel level) {
        if (scope == null) {
            throw new IllegalArgumentException("Invalid logging scope detected in the configuration. Scope cannot be null.");
        }
        if (level == null) {
            throw new IllegalArgumentException("Invalid logging level for scope " + scope + "detected in the configuration. Level cannot be null.");
        }
        if (artifact == null) {
            throw new NoSuchElementException("Could not find artifact to change log level to");
        }
        ClassLoader appClassLoader = artifact.getArtifactClassLoader().getClassLoader();
        ClassUtils.withContextClassLoader((ClassLoader)appClassLoader, () -> {
            LoggerContext loggerContext = (LoggerContext)LogManager.getContext((ClassLoader)appClassLoader, (boolean)false);
            Configuration configuration = loggerContext.getConfiguration();
            configuration.removeLogger(scope);
            configuration.addLogger(scope, new LoggerConfig(scope, Level.getLevel((String)level.name()), true));
            LinkedList<String> configuredArtifactScopes = this.configuredScopes.containsKey(artifact) ? this.configuredScopes.get(artifact) : new LinkedList<String>();
            configuredArtifactScopes.add(scope);
            this.configuredScopes.put(artifact, configuredArtifactScopes);
            loggerContext.updateLoggers(configuration);
        });
    }

    private void clearArtifactLoggingLevel(Artifact artifact, String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Request needs to specify a valid logging scope");
        }
        if (artifact == null) {
            throw new NoSuchElementException("Could not find artifact to change log level to");
        }
        if (artifact.getArtifactClassLoader() == null) {
            LOGGER.debug("Unable to clean logging configuration for application {}", (Object)artifact.getArtifactName());
            return;
        }
        ClassLoader artifactClassLoader = artifact.getArtifactClassLoader().getClassLoader();
        ClassUtils.withContextClassLoader((ClassLoader)artifactClassLoader, () -> {
            LoggerContext loggerContext = (LoggerContext)LogManager.getContext((ClassLoader)artifactClassLoader, (boolean)false);
            Configuration configuration = loggerContext.getConfiguration();
            configuration.removeLogger(scope);
            loggerContext.updateLoggers(configuration);
        });
    }

    private void setAllArtifactsLoggingLevelByApplication(ArtifactLoggingConfiguration artifactLoggingConfiguration) {
        for (ScopeLoggingConfiguration scopeLoggingConfiguration : Arrays.asList(artifactLoggingConfiguration.getScopeLoggingConfigurations())) {
            Application application = this.deploymentService.findApplication(artifactLoggingConfiguration.getArtifactName());
            if (application == null) {
                LOGGER.warn("Unable to set artifact logging level, application {} was not found", (Object)artifactLoggingConfiguration.getArtifactName());
                return;
            }
            if (application.getArtifactClassLoader() == null) {
                LOGGER.warn("Unable to set logging level for application {}, class loader not found", (Object)application.getArtifactName());
                return;
            }
            this.setArtifactLoggingLevel((Artifact)application, scopeLoggingConfiguration.getScope(), scopeLoggingConfiguration.getLogLevel());
        }
    }

    private void setAllArtifactsLoggingLevelByDomain(ArtifactLoggingConfiguration artifactLoggingConfiguration) {
        for (ScopeLoggingConfiguration scopeLoggingConfiguration : Arrays.asList(artifactLoggingConfiguration.getScopeLoggingConfigurations())) {
            Domain domain = this.deploymentService.findDomain(artifactLoggingConfiguration.getArtifactName());
            if (domain != null) {
                this.setArtifactLoggingLevel((Artifact)domain, scopeLoggingConfiguration.getScope(), scopeLoggingConfiguration.getLogLevel());
                continue;
            }
            LOGGER.warn("Unable to set artifact logging level, Domain {} was not found.", (Object)artifactLoggingConfiguration.getArtifactName());
        }
    }

    private class LogApplicationDeploymentListener
    implements DeploymentListener {
        private LogApplicationDeploymentListener() {
        }

        public void onDeploymentSuccess(String artifactName) {
            ArtifactLoggingConfiguration desiredArtifactLoggingConfiguration = null;
            for (ArtifactLoggingConfiguration artifactLoggingConfiguration : Arrays.asList(MuleAgentLoggingService.this.applicationLogLevels)) {
                if (!artifactName.equals(artifactLoggingConfiguration.getArtifactName())) continue;
                desiredArtifactLoggingConfiguration = artifactLoggingConfiguration;
            }
            if (desiredArtifactLoggingConfiguration != null) {
                MuleAgentLoggingService.this.setAllArtifactsLoggingLevelByApplication(desiredArtifactLoggingConfiguration);
            }
        }
    }

    private class LogDomainDeploymentListener
    implements DeploymentListener {
        private LogDomainDeploymentListener() {
        }

        public void onDeploymentSuccess(String artifactName) {
            ArtifactLoggingConfiguration desiredArtifactLoggingConfiguration = null;
            for (ArtifactLoggingConfiguration artifactLoggingConfiguration : Arrays.asList(MuleAgentLoggingService.this.domainLogLevels)) {
                if (!artifactName.equals(artifactLoggingConfiguration.getArtifactName())) continue;
                desiredArtifactLoggingConfiguration = artifactLoggingConfiguration;
            }
            if (desiredArtifactLoggingConfiguration != null) {
                MuleAgentLoggingService.this.setAllArtifactsLoggingLevelByDomain(desiredArtifactLoggingConfiguration);
            }
        }
    }
}

