/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services;

import com.google.inject.Inject;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.exception.RuntimeShutdownException;
import com.mulesoft.agent.exceptions.StudioManagementException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.StudioManagementService;
import com.mulesoft.agent.services.administration.MuleAgentAdministrationService;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.exception.MuleException;

@Named(value="mule.agent.studio.service")
@Singleton
public class AgentStudioManagementService
extends ConfigurableAgentService
implements StudioManagementService {
    private static final Logger LOGGER = LogManager.getLogger(AgentStudioManagementService.class);
    @Configurable(type=Type.DYNAMIC, value="false", description="Check if Studio is alive")
    private boolean studioCheckerEnabled;
    @Configurable(type=Type.DYNAMIC, description="Locked file name used by Studio while is running")
    private String studioLockFileName;
    @Configurable(type=Type.DYNAMIC, description="File name to lock")
    private String muleLockFileName;
    @Configurable(type=Type.DYNAMIC, value="500", description="Milliseconds for the checker to verify whether Studio is alive")
    private long studioCheckerInterval;
    @Configurable(type=Type.DYNAMIC, value="-1", description="Studio Checker Priority")
    private int studioCheckerPriority;
    @Inject
    private MuleAgentAdministrationService muleAgentAdministrationService;
    private Thread checker;
    private File muleLockFile;
    private FileLock muleLock;
    private RandomAccessFile muleLockRAF;

    public List<InternalMessageHandler> getInternalHandlers() {
        return Collections.emptyList();
    }

    protected void doStart() {
        LOGGER.info("Starting Studio Management Service");
        if (this.studioCheckerEnabled) {
            try {
                this.muleLockFile = new File(System.getProperty("java.io.tmpdir"), this.muleLockFileName);
                this.muleLockFile.deleteOnExit();
                this.muleLockRAF = new RandomAccessFile(this.muleLockFile, "rw");
                FileChannel fileChannel = this.muleLockRAF.getChannel();
                this.muleLock = fileChannel.lock();
                LOGGER.info("Studio Checker is running");
                this.checker = new Thread(new StudioCheckerTask(this.studioLockFileName));
                if (this.studioCheckerPriority != -1) {
                    this.checker.setPriority(this.studioCheckerPriority);
                }
                this.checker.setName("Studio Checker");
                this.checker.start();
            }
            catch (Exception e) {
                throw new StudioManagementException("Error initializing Studio Checker", e);
            }
        }
    }

    protected void doStop() throws MuleException {
        LOGGER.info("Stopping Studio Management Service");
        if (this.studioCheckerEnabled) {
            this.checker.interrupt();
        }
    }

    @Override
    public void stopRuntime() {
        LOGGER.info("Received request to stop runtime");
        if (this.muleLock.isValid()) {
            try {
                this.muleLock.release();
                this.muleLockRAF.close();
                this.muleLockFile.delete();
            }
            catch (ClosedChannelException e) {
                LOGGER.info("Error releasing muleLock file", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("Error releasing Mule lock file", (Throwable)e);
            }
            finally {
                try {
                    LOGGER.info("About to shut down the runtime");
                    this.muleAgentAdministrationService.shutdownRuntime();
                }
                catch (RuntimeShutdownException e) {
                    e.printStackTrace();
                    LOGGER.error("Error on shutting down runtime", (Throwable)e);
                }
            }
        } else {
            LOGGER.info("Runtime already stopped, ignoring this request.");
        }
    }

    private final class StudioCheckerTask
    implements Runnable {
        private String studioLockFileName;

        public StudioCheckerTask(String studioLockFileName) {
            this.studioLockFileName = studioLockFileName;
        }

        @Override
        public void run() {
            try (RandomAccessFile studioLockFile = new RandomAccessFile(new File(System.getProperty("java.io.tmpdir"), this.studioLockFileName), "rw");){
                FileChannel fileChannel = studioLockFile.getChannel();
                while (!Thread.currentThread().isInterrupted()) {
                    try (FileLock studioLock = fileChannel.tryLock();){
                        if (studioLock != null) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    Thread.sleep(AgentStudioManagementService.this.studioCheckerInterval);
                }
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
            LOGGER.info("Stopping runtime");
            AgentStudioManagementService.this.stopRuntime();
        }
    }
}

