/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.studio;

import com.google.inject.Inject;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exceptions.StudioManagementException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.StudioManagementService;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Named(value="studio.requests.handler")
@Path(value="studio")
@Singleton
public class StudioRequestHandler
extends ConfigurableExternalHandler {
    public static final int STUDIO_MANAGEMENT_ERROR_STATUS = 512;
    public static final int SERVER_ERROR_STATUS = 500;
    @Configurable(value="true")
    private boolean enabled;
    @Inject
    private StudioManagementService studioManagementService;

    public void enable(boolean enabled) throws AgentEnableOperationException {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @GET
    @Path(value="runtime/alive")
    public Response isAlive() {
        return Response.ok().build();
    }

    @POST
    @Path(value="runtime/stop")
    public Response stopRuntime() {
        if (this.studioManagementService == null) {
            return Response.noContent().build();
        }
        try {
            this.studioManagementService.stopRuntime();
        }
        catch (StudioManagementException e) {
            return Response.status((int)512).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
        return Response.ok().build();
    }
}

