/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.contract;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.construction.Builder;
import com.mulesoft.mule.runtime.gw.api.contract.NoSla;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import java.io.Serializable;
import java.util.Objects;

public class Contract
implements Serializable {
    private static final long serialVersionUID = 2798205646171486620L;
    private final Sla sla;
    private final Client client;

    private Contract(Client client, Sla sla) {
        this.sla = sla;
        this.client = client;
    }

    public static ContractBuilder builder() {
        return new ContractBuilder();
    }

    public Client client() {
        return this.client;
    }

    public Sla sla() {
        return this.sla;
    }

    public String toString() {
        return "Contract{sla=" + String.valueOf(this.sla) + ", client=" + String.valueOf(this.client) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Contract)) {
            return false;
        }
        Contract that = (Contract)o;
        if (!this.sla.equals(that.sla)) {
            return false;
        }
        return this.client.equals(that.client);
    }

    public int hashCode() {
        int result = this.sla.hashCode();
        result = 31 * result + this.client.hashCode();
        return result;
    }

    public static class ContractBuilder
    implements Builder<Contract> {
        private Sla sla = new NoSla();
        private Client client;

        public ContractBuilder withSla(Sla sla) {
            this.sla = sla;
            return this;
        }

        public ContractBuilder withClient(Client client) {
            this.client = client;
            return this;
        }

        @Override
        public Contract build() {
            Objects.requireNonNull(this.sla, "Cannot create Contract without an SLA");
            Objects.requireNonNull(this.client, "Cannot create Contract without a Client");
            return new Contract(this.client, this.sla);
        }
    }
}

