/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import com.mulesoft.mule.runtime.gw.api.config.RuntimeConfiguration;
import org.apache.commons.lang3.StringUtils;

public class ExternalAuthConfiguration
extends RuntimeConfiguration {
    private static final String EXTERNAL_AUTH_PROVIDER_ENABLE_PROXY = "anypoint.platform.external_authentication_provider_enable_proxy_settings";
    private static final String OAUTH_CACHE_MAX_SIZE_PROPERTY_NAME = "anypoint.platform.oauth2_cache_max_size";
    private static final String OPEN_AM_CACHE_MAX_SIZE_PROPERTY_NAME = "anypoint.platform.open_am_cache_max_size";
    private static final String OPEN_ID_CACHE_MAX_SIZE_PROPERTY_NAME = "anypoint.platform.openid_connect_cache_max_size";
    private static final String PF_CACHE_MAX_SIZE_PROPERY_NAME = "anypoint.platform.ping_federate_cache_max_size";
    private static final long CACHE_MAX_SIZE_DEFAULT = 10000L;

    ExternalAuthConfiguration() {
    }

    public boolean isProxyEnabled() {
        return Boolean.valueOf(StringUtils.trimToNull((String)System.getProperty(EXTERNAL_AUTH_PROVIDER_ENABLE_PROXY, "false")));
    }

    public long getOauthCacheMaxSize() {
        return this.parseLongOrDefault(OAUTH_CACHE_MAX_SIZE_PROPERTY_NAME, 10000L);
    }

    public long getOpenAmCacheMaxSize() {
        return this.parseLongOrDefault(OPEN_AM_CACHE_MAX_SIZE_PROPERTY_NAME, 10000L);
    }

    public long getPingFederateCacheMaxSize() {
        return this.parseLongOrDefault(PF_CACHE_MAX_SIZE_PROPERY_NAME, 10000L);
    }

    public long getOpenIdCacheMaxSize() {
        return this.parseLongOrDefault(OPEN_ID_CACHE_MAX_SIZE_PROPERTY_NAME, 10000L);
    }
}

