/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.service.InternalPolicyDeploymentException;
import com.mulesoft.mule.runtime.gw.policies.service.TransactionalPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.util.ClassUtils;
import java.util.Collections;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalPolicyDeploymentService
implements TransactionalPolicyDeploymentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalPolicyDeploymentService.class);
    private final PolicyFactory policyFactory;
    private final PolicyParametrizationFactory parametrizationFactory;
    private final PolicyParametrizationFactory policyParametrizationFactory = new PolicyParametrizationFactory();

    public InternalPolicyDeploymentService(PolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
        this.parametrizationFactory = new PolicyParametrizationFactory();
    }

    @Override
    public void deploy(PolicyDefinition policyDefinition, Api api) {
        ApiImplementation apiImplementation = api.getImplementation();
        Policy policy = this.policyFactory.createFromPolicyDefinition(policyDefinition);
        ClassUtils.withContextClassLoader((ClassLoader)apiImplementation.getArtifactClassloader(), () -> {
            LOGGER.debug("Deploying internal policy {} for {}", (Object)policyDefinition.getName(), (Object)api);
            try {
                PolicyTemplate policyTemplate = policy.getPolicyTemplate();
                PolicyParametrization policyParametrization = this.parametrizationFactory.create(policy, apiImplementation, policyTemplate.getTemplateFile(), null, false, Collections.emptyList());
                apiImplementation.addPolicy(policyTemplate.getTemplateDescriptor(), policyParametrization);
            }
            catch (Exception e) {
                LOGGER.error("Error deploying internal policy {} to API {}: {}", new Object[]{policyDefinition.getName(), apiImplementation.getApiKey(), e.getMessage()});
                throw new InternalPolicyDeploymentException("Unexpected error deploying internal policy", e);
            }
        });
    }

    @Override
    public void updateOrder(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy, Api api) {
        throw new InternalPolicyDeploymentException("Internal policies should not be reordered");
    }

    @Override
    public void update(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy, Api api) {
        throw new InternalPolicyDeploymentException("Internal policies should not be update");
    }

    @Override
    public void revertPolicy(PolicyDefinition policy, Api api) {
        throw new InternalPolicyDeploymentException("Internal policies should not be reverted");
    }

    @Override
    public void undeploy(PolicyDefinition policyDefinition, Api api) {
        ApiImplementation apiImplementation = api.getImplementation();
        Policy policy = this.policyFactory.createFromPolicyDefinition(policyDefinition);
        ClassUtils.withContextClassLoader((ClassLoader)apiImplementation.getArtifactClassloader(), () -> {
            LOGGER.debug("Removing internal policy {} from {}", (Object)policyDefinition.getName(), (Object)api);
            return apiImplementation.removePolicy(this.policyParametrizationFactory.buildParametrizationId(policy, apiImplementation));
        });
    }
}

