/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.core.template;

import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.alsp.wizard.apis.core.model.APIFragment;
import org.mule.alsp.wizard.apis.core.model.APIFragmentType;
import org.mule.alsp.wizard.apis.core.model.APISpecFormat;
import org.mule.alsp.wizard.apis.core.model.APISpecType;
import org.mule.alsp.wizard.apis.core.model.APISpecVersion;
import org.mule.alsp.wizard.apis.core.model.APISpecification;
import org.mule.alsp.wizard.apis.core.template.APITemplate;
import org.mule.alsp.wizard.apis.core.template.APITemplateFactory;
import org.mule.alsp.wizard.apis.core.template.InMemoryAPITemplateFactory;

public class InMemoryAPITemplateFactoryTest {
    private APITemplateFactory templateFactory;

    @Before
    public void setup() {
        this.templateFactory = new InMemoryAPITemplateFactory();
    }

    @Test
    public void mustGenerateATemplateFromAValidApiSpec() throws Exception {
        APISpecification raml10Spec = new APISpecification(APISpecType.RAML, APISpecVersion.V_1_0_0, APISpecFormat.RAML);
        APITemplate template = this.templateFactory.create(raml10Spec);
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)"#%RAML 1.0\ntitle: <YOUR_TITLE>\nversion: v1", (Object)this.asString(template));
    }

    @Test
    public void mustGenerateATemplateFromAValidApiFragment() throws Exception {
        APISpecification raml10Spec = new APISpecification(APISpecType.RAML, APISpecVersion.V_1_0_0, APISpecFormat.RAML);
        APIFragment dataTypeFragment = new APIFragment(raml10Spec, APIFragmentType.DATA_TYPE);
        APITemplate template = this.templateFactory.create(dataTypeFragment);
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)"#%RAML 1.0 DataType", (Object)this.asString(template));
    }

    @Test
    public void mustGenerateAnEmptyTemplateForUnknownApiSpec() throws Exception {
        APISpecification invalidRaml10Spec = new APISpecification(APISpecType.RAML, APISpecVersion.V_1_0_0, APISpecFormat.JSON);
        APITemplate template = this.templateFactory.create(invalidRaml10Spec);
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)"", (Object)this.asString(template));
    }

    @Test
    public void mustGenerateAnEmptyTemplateForUnknownApiFragment() throws Exception {
        APISpecification invalidRaml10Spec = new APISpecification(APISpecType.RAML, APISpecVersion.V_1_0_0, APISpecFormat.JSON);
        APIFragment dataTypeFragment = new APIFragment(invalidRaml10Spec, APIFragmentType.TRAIT);
        APITemplate template = this.templateFactory.create(dataTypeFragment);
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)"", (Object)this.asString(template));
    }

    private String asString(APITemplate template) {
        return template.writeTo((Writer)new StringWriter()).toString();
    }
}

