/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.core.template;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.alsp.wizard.apis.core.template.APITemplate;

public class APITemplateTest {
    private APITemplate template;

    @Before
    public void setup() {
        this.template = new APITemplate("a test template");
    }

    @Test
    public void mustWriteTemplateToAWriter() throws Exception {
        StringWriter destination = new StringWriter();
        this.template.writeTo((Writer)destination);
        Assert.assertEquals((Object)"a test template", (Object)((Object)destination).toString());
    }

    @Test
    public void mustHandleErrorsWritingToAWriterAndContinueNormally() throws Exception {
        Writer mockDestination = (Writer)Mockito.mock(Writer.class);
        ((Writer)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("failure")}).when((Object)mockDestination)).write(ArgumentMatchers.anyString());
        this.template.writeTo(mockDestination);
    }

    @Test
    public void mustWriteTemplateToANonExistentFile() throws Exception {
        IFile mockFile = (IFile)Mockito.mock(IFile.class);
        ArgumentCaptor valueCapture = ArgumentCaptor.forClass(InputStream.class);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)false);
        ((IFile)Mockito.doNothing().when((Object)mockFile)).create((InputStream)valueCapture.capture(), ArgumentMatchers.eq((boolean)true), (IProgressMonitor)ArgumentMatchers.isNull());
        this.template.writeTo(mockFile);
        String contentSentToWriteInFile = IOUtils.toString((InputStream)((InputStream)valueCapture.getValue()), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"a test template", (Object)contentSentToWriteInFile);
        ((IFile)Mockito.verify((Object)mockFile, (VerificationMode)Mockito.times((int)1))).create((InputStream)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (IProgressMonitor)ArgumentMatchers.any());
    }

    @Test
    public void mustWriteTemplateToAnExistentFileAndKeepPreviousContentsInHistory() throws Exception {
        IFile mockFile = (IFile)Mockito.mock(IFile.class);
        ArgumentCaptor valueCapture = ArgumentCaptor.forClass(InputStream.class);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)true);
        ((IFile)Mockito.doNothing().when((Object)mockFile)).setContents((InputStream)valueCapture.capture(), ArgumentMatchers.eq((int)2), (IProgressMonitor)ArgumentMatchers.any());
        this.template.writeTo(mockFile);
        String contentSentToWriteInFile = IOUtils.toString((InputStream)((InputStream)valueCapture.getValue()), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"a test template", (Object)contentSentToWriteInFile);
        ((IFile)Mockito.verify((Object)mockFile, (VerificationMode)Mockito.times((int)1))).setContents((InputStream)ArgumentMatchers.any(InputStream.class), ArgumentMatchers.anyInt(), (IProgressMonitor)ArgumentMatchers.any());
    }

    @Test
    public void mustHandleErrorsWritingToAFileAndContinueNormally() throws Exception {
        IFile mockFile = (IFile)Mockito.mock(IFile.class);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)false);
        ((IFile)Mockito.doThrow((Throwable[])new Throwable[]{new CoreException(Status.CANCEL_STATUS)}).when((Object)mockFile)).create((InputStream)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (IProgressMonitor)ArgumentMatchers.any());
        this.template.writeTo(mockFile);
    }
}

