/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.core.model;

import org.junit.Assert;
import org.junit.Test;
import org.mule.alsp.wizard.apis.core.model.APISpecFormat;
import org.mule.alsp.wizard.apis.core.model.APISpecType;
import org.mule.alsp.wizard.apis.core.model.APISpecVersion;
import org.mule.alsp.wizard.apis.core.model.APISpecification;

public class APISpecificationTest {
    @Test
    public void mustAddProperExtensionAsSuffixBasedOnFormat() throws Exception {
        APISpecification openApi30yaml = new APISpecification(APISpecType.OPENAPI, APISpecVersion.V_3_0_0, APISpecFormat.YAML);
        APISpecification openApi30json = new APISpecification(APISpecType.OPENAPI, APISpecVersion.V_3_0_0, APISpecFormat.JSON);
        String openApi30yamlFilename = openApi30yaml.completeFilenameWithExtension("test");
        String openApi30jsonFilename = openApi30json.completeFilenameWithExtension("test");
        Assert.assertEquals((Object)"test.yaml", (Object)openApi30yamlFilename);
        Assert.assertEquals((Object)"test.json", (Object)openApi30jsonFilename);
    }

    @Test(expected=NullPointerException.class)
    public void mustFailIfAFilenameIsNotSpecified() throws Exception {
        APISpecification apiSpecification = new APISpecification(APISpecType.OPENAPI, APISpecVersion.V_2_0_0, APISpecFormat.YAML);
        apiSpecification.completeFilenameWithExtension(null);
    }
}

