/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.core.filecreator;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.alsp.wizard.apis.core.filecreator.TemplateBasedAPIFileCreator;
import org.mule.alsp.wizard.apis.core.model.APIFragment;
import org.mule.alsp.wizard.apis.core.model.APIFragmentType;
import org.mule.alsp.wizard.apis.core.model.APISpecFormat;
import org.mule.alsp.wizard.apis.core.model.APISpecType;
import org.mule.alsp.wizard.apis.core.model.APISpecVersion;
import org.mule.alsp.wizard.apis.core.model.APISpecification;
import org.mule.alsp.wizard.apis.core.template.APITemplateFactory;
import org.mule.alsp.wizard.apis.core.template.InMemoryAPITemplateFactory;

public class TemplateBasedAPIFileCreatorTest {
    private TemplateBasedAPIFileCreator apiFileCreator;

    @Before
    public void setup() {
        InMemoryAPITemplateFactory apiTemplateFactory = new InMemoryAPITemplateFactory();
        this.apiFileCreator = new TemplateBasedAPIFileCreator((APITemplateFactory)apiTemplateFactory);
    }

    @Test
    public void mustCreateAndWriteAFileWithTheApiSpecificationContent() throws Exception {
        IFile mockDestination = (IFile)Mockito.mock(IFile.class);
        APISpecification raml10 = new APISpecification(APISpecType.RAML, APISpecVersion.V_1_0_0, APISpecFormat.RAML);
        this.apiFileCreator.create(mockDestination, raml10);
        ((IFile)Mockito.verify((Object)mockDestination)).create((InputStream)ArgumentMatchers.any(InputStream.class), ArgumentMatchers.anyBoolean(), (IProgressMonitor)ArgumentMatchers.any());
    }

    @Test
    public void mustCreateAndWriteAFileWithTheApiFragmentContent() throws Exception {
        IFile mockDestination = (IFile)Mockito.mock(IFile.class);
        APISpecification raml10 = new APISpecification(APISpecType.RAML, APISpecVersion.V_1_0_0, APISpecFormat.RAML);
        APIFragment ramlDataType = new APIFragment(raml10, APIFragmentType.DATA_TYPE);
        this.apiFileCreator.create(mockDestination, ramlDataType);
        ((IFile)Mockito.verify((Object)mockDestination)).create((InputStream)ArgumentMatchers.any(InputStream.class), ArgumentMatchers.anyBoolean(), (IProgressMonitor)ArgumentMatchers.any());
    }
}

