/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.validation;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.alsp.validation.RAMLValidationUtils;

public class RAMLValidationUtilsTest {
    @Test
    public void isRAML10DataType_MustDetectAValidRAML10DataType() {
        String text = "#%RAML 1.0 DataType\ntype: object\nproperties:\n    field1:\n        type: string\n";
        boolean result = RAMLValidationUtils.isRAML10DataType((String)text);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void isRAML10DataType_MustSupportHavingSpacesBetweenTheWordsOfTheHeader() {
        String text = "#   %RAML    1.0    DataType    \ntype: object\nproperties:\n    field1:\n        type: string\n";
        boolean result = RAMLValidationUtils.isRAML10DataType((String)text);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void isRAML10DataType_MustSupportHavingWhitespacesBeforeHeader() {
        String text = "   \n   \n   #%RAML 1.0 DataType\ntype: object\nproperties:\n    field1:\n        type: string\n";
        boolean result = RAMLValidationUtils.isRAML10DataType((String)text);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void isRAML10DataType_MustNotAllowCommentsBeforeHeader() {
        String text = "# This is a comment\n#%RAML 1.0 DataType\ntype: object\nproperties:\n    field1:\n        type: string\n";
        boolean result = RAMLValidationUtils.isRAML10DataType((String)text);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void isRAML10DataType_MustDetectAnInvalidRAML10DataType() {
        String text = "#%RAML 1.0 DataType INVALID\ntype: object\nproperties:\n    field1:\n        type: string\n";
        boolean result = RAMLValidationUtils.isRAML10DataType((String)text);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void isRAML10DataType_MustDetectWhenIsNotARAML10DataType() {
        String text = "#%RAML 1.0 Library\ntypes:\n  test:\n    type: string\n";
        boolean result = RAMLValidationUtils.isRAML10DataType((String)text);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void isRAML10DataType_MustDetectWhenIsNotARAML10DataTypeButValidRAML08WithHeader() {
        String text = "#%RAML 0.8\ntitle: test\nschemas:\n  test:\n    type: string\n";
        boolean result = RAMLValidationUtils.isRAML10DataType((String)text);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void isRAML10DataType_MustDetectWhenIsNotARAML10DataTypeButValidRAML08WithoutHeader() {
        String text = "title: test\nschemas:\n  test:\n    type: string\n";
        boolean result = RAMLValidationUtils.isRAML10DataType((String)text);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void isRAML10DataType_MustDetectAsInvalidAnEmptyText() {
        String text = "";
        boolean result = RAMLValidationUtils.isRAML10DataType((String)text);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void isRAML10DataType_MustDetectAsInvalidANullAsText() {
        String text = null;
        boolean result = RAMLValidationUtils.isRAML10DataType(text);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void validateRAML10DataType_MustNotReturnErrorsWithValidRAML10DataType() {
        String text = "#%RAML 1.0 DataType\ntype: object\nproperties:\n    field1:\n        type: string\n";
        List results = RAMLValidationUtils.validateRAML10DataType((String)text);
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((String)"Expected an empty validation error list", (boolean)results.isEmpty());
    }

    @Test
    public void validateRAML10DataType_MustReturnErrorsWithInvalidRAML10DataType() {
        String text = "#%RAML 1.0 DataType\ntype_INVALID: object\nproperties:\n    field1:\n        type: string\n";
        List results = RAMLValidationUtils.validateRAML10DataType((String)text);
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((String)"Expected to have validation errors", (boolean)results.isEmpty());
    }

    @Test
    public void validateRAML10DataType_MustReturnErrorsWhenItIsNotARAML10DataType() {
        String text = "#%RAML 1.0 Library\ntypes:\n  test:\n    type: string\n";
        List results = RAMLValidationUtils.validateRAML10DataType((String)text);
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((String)"Expected to have validation errors", (boolean)results.isEmpty());
    }

    @Test
    public void validateRAML10DataType_MustReturnErrorsWhenItIsNotARAML10DataTypeButValidRAML08WithHeader() {
        String text = "#%RAML 0.8\ntitle: test\nschemas:\n  test:\n    type: string\n";
        List results = RAMLValidationUtils.validateRAML10DataType((String)text);
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((String)"Expected to have validation errors", (boolean)results.isEmpty());
    }

    @Test
    public void validateRAML10DataType_MustReturnErrorsWhenItIsNotARAML10DataTypeButValidRAML08WithoutHeader() {
        String text = "title: test\nschemas:\n  test:\n    type: string\n";
        List results = RAMLValidationUtils.validateRAML10DataType((String)text);
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((String)"Expected to have validation errors", (boolean)results.isEmpty());
    }

    @Test
    public void validateRAML10DataType_MustReturnErrorsOnEmptyText() {
        String text = "";
        List results = RAMLValidationUtils.validateRAML10DataType((String)text);
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((String)"Expected to have validation errors", (boolean)results.isEmpty());
    }

    @Test
    public void validateRAML10DataType_MustReturnErrorsOnNullAsText() {
        String text = null;
        List results = RAMLValidationUtils.validateRAML10DataType(text);
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((String)"Expected to have validation errors", (boolean)results.isEmpty());
    }
}

