/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.strategies;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.mule.alsp.telemetry.TelemetryMessageTypes;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.lsp.ClientTextDocumentService;
import org.mule.alsp.testapi.lsp.TestLanguageClient;
import org.mule.alsp.testapi.params.ValidationTestParams;
import org.mule.alsp.testapi.strategies.ITestStrategy;
import org.mule.alsp.testapi.strategies.ManageDocumentStrategy;

public class ValidationTestStrategy
implements ITestStrategy<ValidationTestParams> {
    private static final Pattern ERRORS_FILE_HEADER_PATTERN = Pattern.compile("\\d+:\\d+\\s-\\s.*");
    private final ManageDocumentStrategy manageDocument;
    private final ClientTextDocumentService clientTextDocumentService;

    public ValidationTestStrategy(LanguageServer serverProxy, ClientTextDocumentService clientTextDocumentService) {
        this.manageDocument = new ManageDocumentStrategy(serverProxy);
        this.clientTextDocumentService = clientTextDocumentService;
    }

    @Override
    public void test(ValidationTestParams testParams) {
        block7: {
            try {
                if (testParams.getExpectedResultURI() != null && testParams.getValidationIssues() == null) {
                    File errorsListFile = new File(testParams.getExpectedResultURI());
                    if (testParams.isRewriteExpected()) {
                        if (errorsListFile.exists()) {
                            errorsListFile.delete();
                        }
                        errorsListFile = new File(errorsListFile.toURI());
                        errorsListFile.createNewFile();
                    }
                    List<String> issues = this.validationTest(testParams.getUri(), testParams.getName());
                    if (testParams.isRewriteExpected()) {
                        FileUtils.writeLines((File)errorsListFile, issues, (boolean)false);
                    }
                    List<String> expectedIssues = this.readFileOfExpectedIssues(errorsListFile);
                    MatcherAssert.assertThat(issues, (Matcher)CoreMatchers.is(expectedIssues));
                    break block7;
                }
                if (testParams.getExpectedResultURI() == null && testParams.getValidationIssues() != null) {
                    List<String> issues = this.validationTest(testParams.getUri(), testParams.getName());
                    MatcherAssert.assertThat(issues, (Matcher)CoreMatchers.is(testParams.getValidationIssues()));
                    break block7;
                }
                throw new IllegalArgumentException("Should either be errorsFileURI or validationIssues");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    private List<String> readFileOfExpectedIssues(File errorsListFile) throws IOException {
        ArrayList<String> expectedIssues = new ArrayList<String>();
        if (!errorsListFile.exists()) {
            return expectedIssues;
        }
        List<String> lineList = Files.readAllLines(errorsListFile.toPath(), Charset.defaultCharset());
        for (String line : lineList) {
            if (line == null) continue;
            if (ERRORS_FILE_HEADER_PATTERN.matcher(line).matches()) {
                expectedIssues.add(line);
                continue;
            }
            int lastIndex = expectedIssues.size() - 1;
            String newLine = ((String)expectedIssues.get(lastIndex)).concat("\n").concat(line);
            expectedIssues.set(lastIndex, newLine);
        }
        return expectedIssues;
    }

    private List<String> validationTest(URI uri, String testName) throws IOException, InterruptedException, ExecutionException {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> null);
        this.manageDocument.openDocument(uri);
        String uriString = TestUtils.patchUri(uri);
        long startedAt = this.clientTextDocumentService.startTimingAndTelemetry(uriString, TelemetryMessageTypes.BEGIN_ALSP_DIAGNOSTCS, true, true);
        TestApi.getTelemetryManager().tryGetEvent(TestUtils.patchUri(uri), 1000L, TelemetryMessageTypes.END_DIAGNOSTIC, false);
        PublishDiagnosticsParams params = TestLanguageClient.validationHandler.tryGet(uriString);
        this.clientTextDocumentService.finishTimingAndTelemetry(uriString, TelemetryMessageTypes.END_ALSP_DIAGNOSTCS, startedAt, future, true, true);
        ArrayList<String> issuesList = new ArrayList<String>();
        params.getDiagnostics().forEach(diagnostic -> {
            try {
                File tmpFile = new File(new URI(params.getUri()));
                URI tmpParentUri = tmpFile.getParentFile().toURI();
                diagnostic.setMessage(diagnostic.getMessage().replaceAll(TestUtils.patchUri(tmpParentUri), ""));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            issuesList.add(diagnostic.getRange().getStart().getLine() + ":" + diagnostic.getRange().getStart().getCharacter() + " - " + diagnostic.getMessage());
        });
        Collections.sort(issuesList);
        return issuesList;
    }

    @Override
    public void cleanup(ValidationTestParams testParams) {
        this.manageDocument.closeDocument(testParams.getUri());
    }
}

