/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.strategies;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.junit.Assert;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.params.SuggestionTestParams;
import org.mule.alsp.testapi.strategies.ITestStrategy;
import org.mule.alsp.testapi.strategies.ManageDocumentStrategy;

public class SuggestionTestStrategy
implements ITestStrategy<SuggestionTestParams> {
    private final ManageDocumentStrategy manageDocument;
    private LanguageServer serverProxy;

    public SuggestionTestStrategy(LanguageServer serverProxy) {
        this.serverProxy = serverProxy;
        this.manageDocument = new ManageDocumentStrategy(serverProxy);
    }

    @Override
    public void test(SuggestionTestParams testParams) {
        try {
            Map<Position, List<String>> proposalItems = null;
            String content = TestUtils.readFile(testParams.getUri());
            String preparedContent = TestUtils.removePlaceholder(content);
            HashMap<List<String>, CompletionParams> completionParams = new HashMap<List<String>, CompletionParams>();
            File proposalItemsFile = null;
            if (testParams.getExpectedResultURI() != null) {
                proposalItemsFile = new File(testParams.getExpectedResultURI());
                proposalItems = TestUtils.parseSuggestionFile(testParams.getExpectedResultURI(), testParams.isRewriteExpected());
                if (testParams.isRewriteExpected()) {
                    if (!proposalItemsFile.exists()) {
                        proposalItemsFile.getParentFile().mkdirs();
                        proposalItemsFile.createNewFile();
                    }
                    PrintWriter printWriter = new PrintWriter(proposalItemsFile);
                    printWriter.print("");
                    printWriter.close();
                }
                if (!proposalItems.isEmpty()) {
                    for (Map.Entry<Object, Object> entry : proposalItems.entrySet()) {
                        CompletionParams params = new CompletionParams(new TextDocumentIdentifier(TestUtils.patchUri(testParams.getUri())), (Position)entry.getKey());
                        completionParams.put((List)entry.getValue(), params);
                    }
                } else {
                    CompletionParams completionParams2 = new CompletionParams(new TextDocumentIdentifier(TestUtils.patchUri(testParams.getUri())), new Position(0, 0));
                    completionParams.put(new ArrayList(), completionParams2);
                }
            } else if (testParams.getProposalItems() != null) {
                CompletionParams completionParams3 = new CompletionParams(new TextDocumentIdentifier(TestUtils.patchUri(testParams.getUri())), TestUtils.toPosition(content.indexOf(42), preparedContent));
                completionParams.put(testParams.getProposalItems(), completionParams3);
            }
            this.manageDocument.openDocument(testParams.getUri(), preparedContent);
            for (Map.Entry entry : completionParams.entrySet()) {
                List<String> list = this.suggestionsTest((CompletionParams)entry.getValue(), (List)entry.getKey(), "");
                list.sort(TestUtils.STRING_COMPARATOR);
                String listString = String.join((CharSequence)";", list);
                if (testParams.isRewriteExpected() && proposalItemsFile != null) {
                    FileUtils.write((File)proposalItemsFile, (CharSequence)(((CompletionParams)entry.getValue()).getPosition().getLine() + ":" + ((CompletionParams)entry.getValue()).getPosition().getCharacter() + " - " + listString + ";\n"), (boolean)true);
                }
                ((List)entry.getKey()).sort(TestUtils.STRING_COMPARATOR);
                ArrayList extras = new ArrayList();
                ArrayList necessary = new ArrayList();
                list.forEach(item -> {
                    if (!((List)entry.getKey()).contains(item)) {
                        extras.add(item);
                    }
                });
                ((List)entry.getKey()).forEach(item -> {
                    if (!list.contains(item)) {
                        necessary.add(item);
                    }
                });
                Assert.assertEquals((String)("\nextra: " + String.valueOf(extras) + "\nnecessary: " + String.valueOf(necessary) + "\n"), (long)((List)entry.getKey()).size(), (long)list.size());
                int i = 0;
                while (i < list.size()) {
                    String expected = (String)((List)entry.getKey()).get(i);
                    String actual = list.get(i);
                    if (expected != null) {
                        expected = expected.replaceAll(" ", ".").replaceAll("\t", "\\\\t").replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
                    }
                    if (actual != null) {
                        actual = actual.replaceAll(" ", ".").replaceAll("\t", "\\\\t").replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
                    }
                    Assert.assertEquals((Object)expected, (Object)actual);
                    ++i;
                }
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            e.printStackTrace();
            Assert.fail((String)"Can't load suggestions from LanguageServer");
            Thread.currentThread().interrupt();
        }
    }

    private List<String> suggestionsTest(CompletionParams params, List<String> proposalItems, String testName) throws IOException, InterruptedException, ExecutionException {
        List items = null;
        try {
            items = (List)((Either)this.serverProxy.getTextDocumentService().completion(params).get(5L, TimeUnit.SECONDS)).getLeft();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        if (items != null) {
            for (CompletionItem item : items) {
                String text = item.getInsertText();
                if (text == null) {
                    Either textEditEither = item.getTextEdit();
                    text = textEditEither.isLeft() ? ((TextEdit)textEditEither.getLeft()).getNewText() : ((InsertReplaceEdit)textEditEither.getRight()).getNewText();
                }
                suggestions.add(text);
            }
        }
        Thread.sleep(100L);
        return suggestions;
    }

    @Override
    public void cleanup(SuggestionTestParams testParams) {
        this.manageDocument.closeDocument(testParams.getUri());
    }
}

