/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.strategies;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageServer;
import org.json.JSONObject;
import org.junit.Assert;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.params.StructureTestPrams;
import org.mule.alsp.testapi.strategies.ITestStrategy;
import org.mule.alsp.testapi.strategies.ManageDocumentStrategy;

public class StructureTestStrategy
implements ITestStrategy<StructureTestPrams> {
    private final ManageDocumentStrategy manageDocument;
    private LanguageServer serverProxy;

    public StructureTestStrategy(LanguageServer serverProxy) {
        this.serverProxy = serverProxy;
        this.manageDocument = new ManageDocumentStrategy(serverProxy);
    }

    @Override
    public void test(StructureTestPrams testParams) {
        try {
            this.manageDocument.openDocument(testParams.getUri());
            DocumentSymbolParams params = new DocumentSymbolParams(new TextDocumentIdentifier(TestUtils.patchUri(testParams.getUri())));
            Thread.sleep(50L);
            List list = (List)this.serverProxy.getTextDocumentService().documentSymbol(params).get(5L, TimeUnit.SECONDS);
            JSONObject obj = TestUtils.dumpStructureToJSON(TestUtils.buildStructureTree(list, testParams.getUri()), params.getTextDocument());
            Assert.assertTrue((String)testParams.getName(), (obj != null && obj.length() > 0 ? 1 : 0) != 0);
            File jsonFile = new File(testParams.getExpectedResultURI());
            if (testParams.isRewriteExpected()) {
                FileUtils.writeStringToFile((File)jsonFile, (String)TestUtils.asString(obj));
            } else if (!jsonFile.exists()) {
                throw new IllegalArgumentException(testParams.getName() + " : Outline json file does not exist");
            }
            JSONObject expected = new JSONObject(TestUtils.readFile(testParams.getExpectedResultURI()));
            TestUtils.compareStructureRoot(expected, obj, testParams.getName());
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void cleanup(StructureTestPrams testParams) {
        this.manageDocument.closeDocument(testParams.getUri());
    }
}

