/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.strategies;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.services.LanguageServer;
import org.mule.alsp.testapi.TestUtils;

public class ManageDocumentStrategy {
    private LanguageServer serverProxy;
    private static final Map<String, Long> concurrentActivitiesForFile = new HashMap<String, Long>();

    public ManageDocumentStrategy(LanguageServer serverProxy) {
        this.serverProxy = serverProxy;
    }

    public int openDocument(URI uri) throws IOException {
        String content = IOUtils.toString((URI)uri);
        this.openDocument(uri, content);
        return content.indexOf(42);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDocument(URI uri, String content) {
        TextDocumentItem textDocument = new TextDocumentItem(TestUtils.patchUri(uri), "RAML", 0, content);
        DidOpenTextDocumentParams params = new DidOpenTextDocumentParams(textDocument);
        String uriString = params.getTextDocument().getUri();
        Map<String, Long> map = concurrentActivitiesForFile;
        synchronized (map) {
            if (!concurrentActivitiesForFile.containsKey(uriString)) {
                concurrentActivitiesForFile.put(uriString, 1L);
                this.serverProxy.getTextDocumentService().didOpen(params);
            } else {
                Long val = concurrentActivitiesForFile.get(uriString) + 1L;
                concurrentActivitiesForFile.put(uriString, val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDocument(URI uri) {
        DidCloseTextDocumentParams params = new DidCloseTextDocumentParams(new TextDocumentIdentifier(TestUtils.patchUri(uri)));
        String uriString = params.getTextDocument().getUri();
        Map<String, Long> map = concurrentActivitiesForFile;
        synchronized (map) {
            if (concurrentActivitiesForFile.containsKey(uriString)) {
                Long val = concurrentActivitiesForFile.get(uriString) - 1L;
                if (val <= 0L) {
                    concurrentActivitiesForFile.remove(uriString);
                    this.serverProxy.getTextDocumentService().didClose(params);
                } else {
                    concurrentActivitiesForFile.put(uriString, val);
                }
            }
        }
    }

    public static Map<String, Long> getConcurrentactivitiesforfile() {
        return concurrentActivitiesForFile;
    }
}

