/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.performance.report;

import org.mule.alsp.telemetry.TelemetryType;
import org.mule.alsp.testapi.performance.report.IPerformanceReportWriter;
import org.mule.alsp.testapi.performance.report.PerformanceCriteriaResult;
import org.mule.alsp.testapi.performance.report.PerformanceResultsRepository;

public class ConsolePerformanceReportWriter
implements IPerformanceReportWriter {
    protected String getLine(PerformanceCriteriaResult result, String format) {
        String key = result.getParamName();
        String type = "FULL";
        if (result.getType() != TelemetryType.METHOD_CALL) {
            type = result.getType().name();
        }
        return String.format(format, key, result.getMethod(), type, result.getLimit(), result.getResult(), result.getCount(), result.getAvgLimit(), result.getAvgResult(), result.isPassed());
    }

    @Override
    public void processResults(PerformanceResultsRepository performanceResults) {
        System.out.println(String.format("%100s    %30s    %20s    %10s    %10s    %10s    %10s    %10s    %10s", "Test name", "Object", "Type", "Limit", "Max result", "Count", "Avg. Limit", "Avg. Result", "Status"));
        for (PerformanceCriteriaResult result : performanceResults.getResults()) {
            System.out.println(this.getLine(result, "%100s    %30s    %20s    %10d    %10.1f    %10d    %10.2f    %10.2f    %10s"));
        }
    }
}

