/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.performance.report;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.io.FileUtils;
import org.mule.alsp.testapi.performance.report.ConsolePerformanceReportWriter;
import org.mule.alsp.testapi.performance.report.PerformanceCriteriaResult;
import org.mule.alsp.testapi.performance.report.PerformanceResultsRepository;

public class CSVPerformanceReportWriter
extends ConsolePerformanceReportWriter {
    private String name;
    private final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public CSVPerformanceReportWriter(String name) {
        this.name = name;
    }

    @Override
    public void processResults(PerformanceResultsRepository performanceResults) {
        File performanceFolder = new File("target/performance");
        performanceFolder.mkdir();
        String timestamp = this.timestampFormat.format(Calendar.getInstance().getTime());
        File reportFile = new File(performanceFolder, this.name + "_" + timestamp + "_perf.csv");
        try {
            FileUtils.write((File)reportFile, (CharSequence)String.format("%s;%s;%s;%s;%s;%s;%s;%s;%s%n", "Test name", "Object", "Type", "Limit", "Max result", "Count", "Avg. Limit", "Avg. Result", "Status"));
            for (PerformanceCriteriaResult result : performanceResults.getResults()) {
                FileUtils.write((File)reportFile, (CharSequence)this.getLine(result, "%s;%s;%s;%d;%.1f;%d;%.1f;%.2f;%s%n"), (boolean)true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

