/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.performance;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.mule.alsp.telemetry.TelemetryType;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.performance.TimingTest;
import org.mule.alsp.testapi.performance.report.CSVPerformanceReportWriter;
import org.mule.alsp.testapi.performance.report.ConsolePerformanceReportWriter;
import org.mule.alsp.testapi.performance.report.IPerformanceReportWriter;
import org.mule.alsp.testapi.performance.report.PerformanceCriteriaResult;

public class PerformanceUtils {
    public static final String PERFORMANCE_REPORT = "performance.report";

    private PerformanceUtils() {
    }

    public static IPerformanceReportWriter initializePerformanceReporter(String name) {
        String reportGenerator = System.getProperty(PERFORMANCE_REPORT, "console");
        ConsolePerformanceReportWriter performanceReport = null;
        performanceReport = "console".equalsIgnoreCase(reportGenerator) ? new ConsolePerformanceReportWriter() : new CSVPerformanceReportWriter(name);
        return performanceReport;
    }

    public static TimingTest findDefaultTiming(TimingTest[] telemetryConfigs, TimingTest defaultTiming) {
        TimingTest annotation = Arrays.asList(telemetryConfigs).stream().filter(tc -> tc.telemetryEvent() == TelemetryType.METHOD_CALL).findFirst().orElse(null);
        if (annotation == null) {
            annotation = defaultTiming;
        }
        return annotation;
    }

    public static EnumMap<TelemetryType, TimingTest> getTelemetryConfig(TimingTest[] telemetryConfigs, Map<TelemetryType, TimingTest> telemetryLimits, Map<TimingTest, PerformanceCriteriaResult> telemetryParamLimits, int count) {
        EnumMap<TelemetryType, TimingTest> outTelemetryLimits = new EnumMap<TelemetryType, TimingTest>(TelemetryType.class);
        if (telemetryLimits != null) {
            outTelemetryLimits.putAll(telemetryLimits);
            if (telemetryParamLimits != null) {
                for (Map.Entry<TelemetryType, TimingTest> entry : telemetryLimits.entrySet()) {
                    PerformanceCriteriaResult pair = telemetryParamLimits.values().stream().filter(tr -> tr.getType() == entry.getKey() && tr.getParamName().equals(((TimingTest)entry.getValue()).name())).findFirst().orElse(new PerformanceCriteriaResult());
                    pair.setLimit(entry.getValue().value());
                    pair.setAvgLimit(entry.getValue().avgTime());
                    pair.setCount(count);
                    pair.setParamName(entry.getValue().name());
                    pair.setType(entry.getKey());
                    telemetryParamLimits.put(entry.getValue(), pair);
                }
            }
        }
        if (telemetryConfigs != null) {
            TimingTest[] timingTestArray = telemetryConfigs;
            int n = telemetryConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                TimingTest config = timingTestArray[n2];
                if (config.value() > 0L) {
                    TestApi.setTelemetryEnabled(true);
                    if (telemetryParamLimits != null) {
                        TimingTest existing = telemetryParamLimits.keySet().stream().filter(tr -> tr.telemetryEvent() == config.telemetryEvent() && tr.name().equals(config.name())).findFirst().orElse(null);
                        PerformanceCriteriaResult pair = telemetryParamLimits.getOrDefault(existing, new PerformanceCriteriaResult());
                        pair.setLimit(config.value());
                        pair.setAvgLimit(config.avgTime());
                        pair.setCount(count);
                        pair.setParamName(config.name());
                        pair.setType(config.telemetryEvent());
                        telemetryParamLimits.remove(existing);
                        telemetryParamLimits.put(config, pair);
                    }
                    outTelemetryLimits.put(config.telemetryEvent(), config);
                }
                ++n2;
            }
        }
        return outTelemetryLimits;
    }

    public static TimingTest cloneTimingTest(final TimingTest toClone) {
        return new TimingTest(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return toClone.annotationType();
            }

            @Override
            public long value() {
                return toClone.value();
            }

            @Override
            public TelemetryType telemetryEvent() {
                return toClone.telemetryEvent();
            }

            @Override
            public boolean skip() {
                return toClone.skip();
            }

            @Override
            public String name() {
                return toClone.name();
            }

            @Override
            public int parallel() {
                return toClone.parallel();
            }

            @Override
            public int count() {
                return toClone.count();
            }

            @Override
            public float avgTime() {
                return toClone.avgTime();
            }
        };
    }
}

