/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.performance;

import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.parameterized.BlockJUnit4ClassRunnerWithParameters;
import org.junit.runners.parameterized.TestWithParameters;
import org.mule.alsp.testapi.performance.IgnoreParameterized;
import org.mule.alsp.testapi.performance.ParallelScheduler;
import org.mule.alsp.testapi.performance.PerformanceInvokeMethod;
import org.mule.alsp.testapi.performance.PerformanceRunner;
import org.mule.alsp.testapi.performance.RunnerConfig;
import org.mule.alsp.testapi.performance.report.PerformanceResultsRepository;

public class PerformanceRunnerWithParameters
extends BlockJUnit4ClassRunnerWithParameters {
    private final RunnerConfig config;
    private PerformanceResultsRepository performanceResults;

    public PerformanceRunnerWithParameters(TestWithParameters test) throws InitializationError {
        super(test);
        Class klass = test.getTestClass().getJavaClass();
        PerformanceRunner runner = new PerformanceRunner(klass);
        this.performanceResults = runner.performanceResults;
        this.config = runner.getConfig();
        if (this.config.getThreads() > 1) {
            this.setScheduler(new ParallelScheduler(this.config.getThreads()));
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if ("true".equals(System.getProperty("performance.skip"))) {
            return super.methodInvoker(method, test);
        }
        PerformanceInvokeMethod stmt = new PerformanceInvokeMethod(method, this.describeChild(method), test, this.config, this.performanceResults);
        return stmt;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.config.setNotifier(notifier);
        super.runChild(method, notifier);
    }

    public void run(RunNotifier notifier) {
        this.config.setNotifier(notifier);
        super.run(notifier);
    }

    protected boolean isIgnored(FrameworkMethod child) {
        return super.isIgnored(child) || this.isIgnoredParameterized(child);
    }

    private boolean isIgnoredParameterized(FrameworkMethod testMethod) {
        IgnoreParameterized ignoreParameterized = (IgnoreParameterized)testMethod.getAnnotation(IgnoreParameterized.class);
        if (ignoreParameterized == null || StringUtils.isBlank((CharSequence)ignoreParameterized.decisionMethod()) || StringUtils.isBlank((CharSequence)ignoreParameterized.tag())) {
            return false;
        }
        try {
            Object target = this.createTest();
            Method method = target.getClass().getMethod(ignoreParameterized.decisionMethod(), String.class);
            Object result = method.invoke(target, ignoreParameterized.tag());
            return (Boolean)result;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

