/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.performance;

import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.performance.ParallelScheduler;
import org.mule.alsp.testapi.performance.PerformanceInvokeMethod;
import org.mule.alsp.testapi.performance.PerformanceUtils;
import org.mule.alsp.testapi.performance.RunnerConfig;
import org.mule.alsp.testapi.performance.TimingTest;
import org.mule.alsp.testapi.performance.UsePerformanceRunnerConfiguration;
import org.mule.alsp.testapi.performance.report.IPerformanceReportWriter;
import org.mule.alsp.testapi.performance.report.PerformanceResultsRepository;

public class PerformanceRunner
extends BlockJUnit4ClassRunner {
    public static final String SKIP_PERFORMANCE = "performance.skip";
    private final RunnerConfig config = new RunnerConfig();
    PerformanceResultsRepository performanceResults = new PerformanceResultsRepository();
    IPerformanceReportWriter performanceReport = null;

    public PerformanceRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.performanceResults.getResults().clear();
        UsePerformanceRunnerConfiguration runnerAnnotationConfig = klass.getAnnotation(UsePerformanceRunnerConfiguration.class);
        if (runnerAnnotationConfig != null) {
            int threads = runnerAnnotationConfig.threads();
            if (System.getProperty("performance.threads") != null) {
                threads = Integer.valueOf(System.getProperty("performance.threads"));
            }
            if (threads > 0) {
                this.config.setThreads(threads);
                if (this.config.getThreads() > 1) {
                    this.setScheduler(new ParallelScheduler(this.config.getThreads()));
                }
            }
        }
        if ("true".equals(System.getProperty(SKIP_PERFORMANCE))) {
            return;
        }
        this.performanceReport = PerformanceUtils.initializePerformanceReporter(klass.getName());
        TestApi.setTimingsEnabled(true);
        TimingTest[] telemetryConfigs = (TimingTest[])klass.getAnnotationsByType(TimingTest.class);
        TimingTest timingConfig = PerformanceUtils.findDefaultTiming(telemetryConfigs, null);
        if (timingConfig != null) {
            this.config.setDefaultTiming(timingConfig);
            this.getConfig().setDefaultTelemetryLimits(PerformanceUtils.getTelemetryConfig((TimingTest[])klass.getAnnotationsByType(TimingTest.class), null, null, this.config.getDefaultTiming().count()));
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if ("true".equals(System.getProperty(SKIP_PERFORMANCE))) {
            return super.methodInvoker(method, test);
        }
        PerformanceInvokeMethod stmt = new PerformanceInvokeMethod(method, this.describeChild(method), test, this.config, this.performanceResults);
        return stmt;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.getConfig().setNotifier(notifier);
        super.runChild(method, notifier);
    }

    public void doReport() {
        this.performanceReport.processResults(this.performanceResults);
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        ArrayList<FrameworkMethod> moreAfters = new ArrayList<FrameworkMethod>(afters);
        if (!"true".equals(System.getProperty(SKIP_PERFORMANCE))) {
            try {
                moreAfters.add(new FrameworkMethod(((Object)((Object)this)).getClass().getDeclaredMethod("doReport", new Class[0])));
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return new RunAfters(statement, moreAfters, (Object)this);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        return super.withAfters(method, target, statement);
    }

    protected Statement withBeforeClasses(Statement statement) {
        return super.withBeforeClasses(statement);
    }

    public RunnerConfig getConfig() {
        return this.config;
    }
}

