/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.performance;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.Ignore;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.mule.alsp.telemetry.TelemetryType;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.params.TestParams;
import org.mule.alsp.testapi.performance.PerformanceUtils;
import org.mule.alsp.testapi.performance.RunnerConfig;
import org.mule.alsp.testapi.performance.TimingTest;
import org.mule.alsp.testapi.performance.report.PerformanceCriteriaResult;
import org.mule.alsp.testapi.performance.report.PerformanceResultsRepository;

class PerformanceInvokeMethod
extends InvokeMethod {
    private FrameworkMethod testMethod;
    private Description description;
    private RunnerConfig config;
    private PerformanceResultsRepository performanceResultsRepository;

    public PerformanceInvokeMethod(FrameworkMethod testMethod, Description description, Object target, RunnerConfig config, PerformanceResultsRepository performanceResultsRepository) {
        super(testMethod, target);
        this.testMethod = testMethod;
        this.description = description;
        this.performanceResultsRepository = performanceResultsRepository;
        this.config = config;
    }

    public void evaluate() throws Throwable {
        if (this.testMethod.getAnnotation(Ignore.class) != null) {
            this.config.getNotifier().fireTestIgnored(this.description);
            return;
        }
        TimingTest[] telemetryConfigs = (TimingTest[])this.testMethod.getMethod().getAnnotationsByType(TimingTest.class);
        TimingTest defaultTiming = PerformanceUtils.findDefaultTiming(telemetryConfigs, this.config.getDefaultTiming());
        if (defaultTiming == null) {
            TestApi.setTimingsEnabled(false);
            TestApi.setTelemetryEnabled(false);
            super.evaluate();
            return;
        }
        HashMap<TimingTest, PerformanceCriteriaResult> individualTelemetryTestParamLimits = new HashMap<TimingTest, PerformanceCriteriaResult>();
        if (telemetryConfigs != null) {
            PerformanceUtils.getTelemetryConfig(telemetryConfigs, this.config.getDefaultTelemetryLimits(), individualTelemetryTestParamLimits, defaultTiming.count());
        }
        if (this.config.getDefaultTelemetryLimits().size() > 0) {
            TestApi.setTelemetryEnabled(true);
        }
        boolean telemetryEnabled = TestApi.isTelemetryEnabled();
        int parallel = defaultTiming.parallel();
        if (parallel == 1) {
            int i = 0;
            while (i < defaultTiming.count()) {
                this.executeChild(this.config.getNotifier(), telemetryEnabled, individualTelemetryTestParamLimits);
                ++i;
            }
            for (Map.Entry singleResults : individualTelemetryTestParamLimits.entrySet()) {
                double partialResult = ((PerformanceCriteriaResult)singleResults.getValue()).getAvgResult();
                if (((PerformanceCriteriaResult)singleResults.getValue()).getCount() <= 1L) continue;
                ((PerformanceCriteriaResult)singleResults.getValue()).setAvgResult(partialResult / (double)((PerformanceCriteriaResult)singleResults.getValue()).getCount());
            }
        }
        this.handleResults(individualTelemetryTestParamLimits);
        TestApi.takeInvocations().clear();
    }

    private void handleResults(Map<TimingTest, PerformanceCriteriaResult> individualTelemetryTestParamLimits) {
        List<TestParams> params = TestApi.takeInvocations();
        for (String testName : params.stream().map(p -> (String)StringUtils.defaultIfBlank((CharSequence)p.getName(), (CharSequence)this.testMethod.getName())).collect(Collectors.toList())) {
            if (individualTelemetryTestParamLimits == null) continue;
            for (Map.Entry<TimingTest, PerformanceCriteriaResult> resultEntry : individualTelemetryTestParamLimits.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)resultEntry.getValue().getParamName()) && StringUtils.isEmpty((CharSequence)resultEntry.getValue().getMethod()) || !StringUtils.isEmpty((CharSequence)resultEntry.getValue().getParamName()) && !resultEntry.getValue().getParamName().equals(testName)) continue;
                PerformanceCriteriaResult result = resultEntry.getValue();
                this.performanceResultsRepository.sendTelemetry(result);
                if (!(result.getAvgLimit() > 0.0) || !(result.getAvgResult() > result.getAvgLimit())) continue;
                this.config.getNotifier().fireTestFailure(new Failure(this.description, (Throwable)((Object)new AssertionError((Object)String.format("Average telemetry %s time of %.1f is greater than %.1f", result.getType().name(), result.getAvgResult(), result.getAvgLimit())))));
            }
        }
    }

    private void executeChild(RunNotifier notifier, boolean telemetryEnabled, Map<TimingTest, PerformanceCriteriaResult> telemetryParams) throws Throwable {
        if (TestApi.takeInvocations() != null) {
            TestApi.takeInvocations().clear();
        }
        super.evaluate();
        List<TestParams> paramsList = TestApi.takeInvocations();
        if (paramsList != null) {
            for (Map.Entry<String, List<TestParams>> paramsEntry : paramsList.stream().collect(Collectors.groupingBy(TestParams::getName)).entrySet()) {
                if (telemetryEnabled) {
                    HashMap<TimingTest, PerformanceCriteriaResult> newResultsToProcess = new HashMap<TimingTest, PerformanceCriteriaResult>();
                    for (Map.Entry<TimingTest, PerformanceCriteriaResult> entry : telemetryParams.entrySet()) {
                        this.processAssertsAndResults(entry, telemetryParams, paramsEntry, notifier, newResultsToProcess);
                    }
                    for (Map.Entry<TimingTest, PerformanceCriteriaResult> entry : newResultsToProcess.entrySet()) {
                        this.processAssertsAndResults(entry, telemetryParams, paramsEntry, notifier, null);
                    }
                    telemetryParams.putAll(newResultsToProcess);
                }
                TestParams params = paramsEntry.getValue().get(0);
                params.getTestStrategy().cleanup(params);
            }
        }
    }

    private void processAssertsAndResults(Map.Entry<TimingTest, PerformanceCriteriaResult> entry, Map<TimingTest, PerformanceCriteriaResult> telemetryParams, Map.Entry<String, List<TestParams>> paramsEntry, RunNotifier notifier, Map<TimingTest, PerformanceCriteriaResult> newResultsToAdd) throws InterruptedException {
        block24: {
            TelemetryType type = entry.getKey().telemetryEvent();
            String paramName = entry.getKey().name();
            TestParams params = paramsEntry.getValue().get(0);
            if (StringUtils.isNotEmpty((CharSequence)paramName) && !paramName.equals(params.getName())) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)paramName) && StringUtils.isNotEmpty((CharSequence)params.getName()) && telemetryParams.values().stream().anyMatch(tp -> tp.getParamName().equals(params.getName()) && tp.getType() == type)) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)paramName) && StringUtils.isNotEmpty((CharSequence)params.getName()) && telemetryParams.values().stream().noneMatch(tp -> tp.getParamName().equals(params.getName()) && tp.getType() == type)) {
                if (newResultsToAdd == null) {
                    return;
                }
                PerformanceCriteriaResult timingResult = new PerformanceCriteriaResult();
                timingResult.setAvgLimit(entry.getKey().avgTime());
                timingResult.setLimit(entry.getKey().value());
                timingResult.setCount(entry.getKey().count());
                newResultsToAdd.put(PerformanceUtils.cloneTimingTest(entry.getKey()), timingResult);
            }
            TestUtils.Wrapper<Long> telemetryTime = new TestUtils.Wrapper<Long>();
            try {
                try {
                    if (entry.getValue().getType() == TelemetryType.METHOD_CALL) {
                        if (TestApi.getTelemetryManager().getTimings().get(TestUtils.patchUri(params.getUri())) == null) {
                            Thread.sleep(1000L);
                        }
                        long result = (Long)TestApi.getTelemetryManager().getTimings().get(TestUtils.patchUri(params.getUri())) / (long)paramsEntry.getValue().size();
                        telemetryTime.setObject(result);
                        TestUtils.assertTiming(TestApi.getTelemetryManager(), TestUtils.patchUri(params.getUri()), entry.getValue().getLimit(), TimeUnit.MILLISECONDS);
                    } else {
                        TestUtils.assertTelemetry(TestApi.getTelemetryManager(), TestUtils.patchUri(params.getUri()), entry.getValue().getLimit(), TimeUnit.MILLISECONDS, type.getEndMessageType(), telemetryTime);
                    }
                }
                catch (AssertionError e) {
                    notifier.fireTestFailure(new Failure(this.description, (Throwable)((Object)e)));
                    if (telemetryTime.getObject() != null) {
                        double nextResult;
                        double existingTelemetryResult = entry.getValue().getResult();
                        if (existingTelemetryResult < (nextResult = (double)telemetryTime.getObject().longValue() / (double)paramsEntry.getValue().size())) {
                            entry.getValue().setResult(nextResult);
                        }
                        if (entry.getValue().getCount() > 1L) {
                            double existingAvgSum = entry.getValue().getAvgResult();
                            entry.getValue().setAvgResult(existingAvgSum + nextResult);
                        }
                        entry.getValue().setParamName(this.testMethod.getName());
                        entry.getValue().setMethod(this.testMethod.getDeclaringClass().getSimpleName());
                        if (!StringUtils.isEmpty((CharSequence)params.getName())) {
                            entry.getValue().setParamName(params.getName());
                            entry.getValue().setMethod(this.testMethod.getName());
                        }
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (telemetryTime.getObject() != null) {
                    double nextResult;
                    double existingTelemetryResult = entry.getValue().getResult();
                    if (existingTelemetryResult < (nextResult = (double)((Long)telemetryTime.getObject()).longValue() / (double)paramsEntry.getValue().size())) {
                        entry.getValue().setResult(nextResult);
                    }
                    if (entry.getValue().getCount() > 1L) {
                        double existingAvgSum = entry.getValue().getAvgResult();
                        entry.getValue().setAvgResult(existingAvgSum + nextResult);
                    }
                    entry.getValue().setParamName(this.testMethod.getName());
                    entry.getValue().setMethod(this.testMethod.getDeclaringClass().getSimpleName());
                    if (!StringUtils.isEmpty((CharSequence)params.getName())) {
                        entry.getValue().setParamName(params.getName());
                        entry.getValue().setMethod(this.testMethod.getName());
                    }
                }
                throw throwable;
            }
            if (telemetryTime.getObject() != null) {
                double nextResult;
                double existingTelemetryResult = entry.getValue().getResult();
                if (existingTelemetryResult < (nextResult = (double)telemetryTime.getObject().longValue() / (double)paramsEntry.getValue().size())) {
                    entry.getValue().setResult(nextResult);
                }
                if (entry.getValue().getCount() > 1L) {
                    double existingAvgSum = entry.getValue().getAvgResult();
                    entry.getValue().setAvgResult(existingAvgSum + nextResult);
                }
                entry.getValue().setParamName(this.testMethod.getName());
                entry.getValue().setMethod(this.testMethod.getDeclaringClass().getSimpleName());
                if (!StringUtils.isEmpty((CharSequence)params.getName())) {
                    entry.getValue().setParamName(params.getName());
                    entry.getValue().setMethod(this.testMethod.getName());
                }
            }
        }
    }
}

