/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.performance;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runners.model.RunnerScheduler;

class ParallelScheduler
implements RunnerScheduler {
    private final ExecutorService threadPool;
    private int threads = 1;

    ParallelScheduler(int threads) {
        this.threads = threads == Integer.MAX_VALUE ? Runtime.getRuntime().availableProcessors() : threads;
        this.threadPool = Executors.newFixedThreadPool(this.threads);
    }

    public void schedule(Runnable childStatement) {
        this.threadPool.submit(childStatement);
    }

    public void finished() {
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Got interrupted", e);
        }
    }
}

