/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.params;

import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.alsp.testapi.params.StructureTestPrams;
import org.mule.alsp.testapi.params.SuggestionTestParams;
import org.mule.alsp.testapi.params.ValidationTestParams;
import org.mule.alsp.testapi.strategies.ITestStrategy;

public class TestParams {
    private URI uri;
    private URI expectedResultURI;
    private String name;
    private boolean rewriteExpected;
    private ITestStrategy<? extends TestParams> testStrategy;

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getExpectedResultURI() {
        return this.expectedResultURI;
    }

    public void setExpectedResultURI(URI expectedResultURI) {
        this.expectedResultURI = expectedResultURI;
    }

    public String getName() {
        return StringUtils.defaultString((String)this.name, (String)"");
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRewriteExpected() {
        return this.rewriteExpected;
    }

    public void setRewriteExpected(boolean rewriteExpected) {
        this.rewriteExpected = rewriteExpected;
    }

    public <T extends TestParams> ITestStrategy<T> getTestStrategy() {
        return this.testStrategy;
    }

    public void setTestStrategy(ITestStrategy<? extends TestParams> testStrategy) {
        this.testStrategy = testStrategy;
    }

    protected void fillTestParams(URI uri, URI expectedResultURI, String testName, boolean rewriteExpected) {
        this.setUri(uri);
        this.setExpectedResultURI(expectedResultURI);
        this.setRewriteExpected(rewriteExpected);
        this.setName(testName);
    }

    public static ValidationTestParams createValidationTestParams(URI uri, URI errorsFileURI, List<String> validationIssues, String testName, boolean rewriteExpected) {
        ValidationTestParams params = new ValidationTestParams();
        params.fillTestParams(uri, errorsFileURI, testName, rewriteExpected);
        params.setValidationIssues(validationIssues);
        return params;
    }

    public static SuggestionTestParams createSuggestionTestParams(URI uri, URI proposalsFileURI, List<String> proposalItems, String testName, boolean rewriteExpected) {
        SuggestionTestParams params = new SuggestionTestParams();
        params.fillTestParams(uri, proposalsFileURI, testName, rewriteExpected);
        params.setProposalItems(proposalItems);
        return params;
    }

    public static StructureTestPrams createStructureTestParams(URI uri, URI jsonUri, String testName, boolean rewriteExpected) {
        StructureTestPrams params = new StructureTestPrams();
        params.fillTestParams(uri, jsonUri, testName, rewriteExpected);
        return params;
    }
}

