/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi.lsp;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DeclarationParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.ImplementationParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.TypeHierarchyPrepareParams;
import org.eclipse.lsp4j.TypeHierarchySubtypesParams;
import org.eclipse.lsp4j.TypeHierarchySupertypesParams;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.mule.alsp.telemetry.TelemetryEvent;
import org.mule.alsp.telemetry.TelemetryManager;
import org.mule.alsp.telemetry.TelemetryMessageTypes;

public class ClientTextDocumentService
implements TextDocumentService {
    private TextDocumentService decorated = null;
    private TelemetryManager telemetryManager;

    public ClientTextDocumentService(TextDocumentService textDocumentService, TelemetryManager telemetryManager) {
        this.decorated = textDocumentService;
        this.telemetryManager = telemetryManager;
    }

    private TelemetryEvent createTelemetryEvent(String uriString, TelemetryMessageTypes messageType, long time) {
        TelemetryEvent rawData = new TelemetryEvent();
        rawData.setEvent(messageType.name());
        rawData.setUri(uriString);
        rawData.setMessageType(messageType);
        rawData.setMessage("");
        rawData.setTime(Long.valueOf(time));
        return rawData;
    }

    public long startTimingAndTelemetry(String uriString, TelemetryMessageTypes messageType, boolean telemetryEnabled, boolean timingEnabled) {
        long startedAt = 0L;
        if (telemetryEnabled) {
            startedAt = System.currentTimeMillis();
            TelemetryEvent startEvent = this.createTelemetryEvent(uriString, messageType, startedAt);
            this.telemetryManager.addRawData(startEvent);
        } else {
            startedAt = System.currentTimeMillis();
        }
        return startedAt;
    }

    public void finishTimingAndTelemetry(String uriString, TelemetryMessageTypes messageType, long startedAt, CompletableFuture<?> future, boolean telemetryEnabled, boolean timingEnabled) {
        if (telemetryEnabled || timingEnabled) {
            future.thenApply(fn -> {
                long finishedAt = System.currentTimeMillis();
                if (telemetryEnabled) {
                    this.telemetryManager.getTimings().put(uriString, finishedAt - startedAt);
                    TelemetryEvent endEvent = this.createTelemetryEvent(uriString, messageType, finishedAt);
                    this.telemetryManager.addRawData(endEvent);
                } else {
                    this.telemetryManager.getTimings().put(uriString, finishedAt - startedAt);
                }
                return fn;
            });
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        boolean telemetryEnabled = this.telemetryManager.isTelemetryEnabled();
        boolean timingEnabled = this.telemetryManager.isTimingsEnabled();
        long startedAt = this.startTimingAndTelemetry(position.getTextDocument().getUri(), TelemetryMessageTypes.BEGIN_ALSP_COMPLETION, telemetryEnabled, timingEnabled);
        CompletableFuture future = this.decorated.completion(position);
        this.finishTimingAndTelemetry(position.getTextDocument().getUri(), TelemetryMessageTypes.END_ALSP_COMPLETION, startedAt, future, telemetryEnabled, timingEnabled);
        return future;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return this.decorated.resolveCompletionItem(unresolved);
    }

    public CompletableFuture<Hover> hover(HoverParams position) {
        return this.decorated.hover(position);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> declaration(DeclarationParams params) {
        return this.decorated.declaration(params);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams position) {
        return this.decorated.definition(position);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams position) {
        return this.decorated.typeDefinition(position);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> implementation(ImplementationParams position) {
        return this.decorated.implementation(position);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return this.decorated.references(params);
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams position) {
        return this.decorated.documentHighlight(position);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        boolean telemetryEnabled = this.telemetryManager.isTelemetryEnabled();
        boolean timingEnabled = this.telemetryManager.isTimingsEnabled();
        long startedAt = this.startTimingAndTelemetry(params.getTextDocument().getUri(), TelemetryMessageTypes.BEGIN_ALSP_STRUCTURE, telemetryEnabled, timingEnabled);
        CompletableFuture future = this.decorated.documentSymbol(params);
        this.finishTimingAndTelemetry(params.getTextDocument().getUri(), TelemetryMessageTypes.END_ALSP_STRUCTURE, startedAt, future, telemetryEnabled, timingEnabled);
        return future;
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        return this.decorated.codeAction(params);
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return this.decorated.codeLens(params);
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return this.decorated.resolveCodeLens(unresolved);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return this.decorated.formatting(params);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return this.decorated.rangeFormatting(params);
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        return this.decorated.onTypeFormatting(params);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return this.decorated.rename(params);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.decorated.didOpen(params);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        this.decorated.didChange(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.decorated.didClose(params);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        this.decorated.didSave(params);
    }

    public void willSave(WillSaveTextDocumentParams params) {
        this.decorated.willSave(params);
    }

    public CompletableFuture<List<TextEdit>> willSaveWaitUntil(WillSaveTextDocumentParams params) {
        return this.decorated.willSaveWaitUntil(params);
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        return this.decorated.documentLink(params);
    }

    public CompletableFuture<DocumentLink> documentLinkResolve(DocumentLink params) {
        return this.decorated.documentLinkResolve(params);
    }

    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        return this.decorated.documentColor(params);
    }

    public CompletableFuture<List<ColorPresentation>> colorPresentation(ColorPresentationParams params) {
        return this.decorated.colorPresentation(params);
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return this.decorated.foldingRange(params);
    }

    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        return this.decorated.prepareRename(params);
    }

    public CompletableFuture<List<TypeHierarchyItem>> typeHierarchySubtypes(TypeHierarchySubtypesParams params) {
        return this.decorated.typeHierarchySubtypes(params);
    }

    public CompletableFuture<List<TypeHierarchyItem>> typeHierarchySupertypes(TypeHierarchySupertypesParams params) {
        return this.decorated.typeHierarchySupertypes(params);
    }

    public CompletableFuture<List<TypeHierarchyItem>> prepareTypeHierarchy(TypeHierarchyPrepareParams params) {
        return this.decorated.prepareTypeHierarchy(params);
    }
}

