/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.mule.alsp.telemetry.TelemetryEvent;
import org.mule.alsp.telemetry.TelemetryManager;
import org.mule.alsp.telemetry.TelemetryMessageTypes;
import org.mule.alsp.testapi.TestTelemetryManager;

public class TestUtils {
    private static final String KIND = "kind";
    private static final String SELECTION_RANGE = "selectionRange";
    private static final String DEPRECATED = "deprecated";
    private static final String NAME = "name";
    private static final String CHILDREN = "children";
    private static final String RANGE = "range";
    private static final String START = "start";
    private static final String LINE = "line";
    private static final String CHARACTER = "character";
    private static final String RESULT = "result";
    private static String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static final Comparator<String> STRING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    };

    private TestUtils() {
    }

    public static int toOffset(Position position, String content) {
        return TestUtils.getOffset(position.getLine() + 1, position.getCharacter() + 1, content);
    }

    private static int getOffset(int row, int column, String content) {
        if (row < 0 || column < 0) {
            return -1;
        }
        int offset = column;
        BufferedReader reader = new BufferedReader(new StringReader(content));
        int i = 1;
        while (i < row) {
            try {
                offset += reader.readLine().length() + 1;
            }
            catch (IOException iOException) {
                break;
            }
            ++i;
        }
        return offset - 1;
    }

    public static Position toPosition(int offset, String content) {
        if (offset < 0) {
            return new Position(-1, -1);
        }
        if (offset >= content.length()) {
            offset = content.length() - 1;
        }
        String cut = content.substring(0, offset);
        BufferedReader reader = new BufferedReader(new StringReader(cut));
        int row = -1;
        int column = 0;
        boolean lastEmpty = cut.endsWith("\n");
        try {
            String line = reader.readLine();
            while (line != null) {
                ++row;
                column = line.length();
                line = reader.readLine();
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        if (lastEmpty) {
            ++row;
            column = 0;
        }
        return new Position(row, column);
    }

    public static String readFile(URI file) {
        try {
            return FileUtils.readFileToString((File)new File(file), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String removePlaceholder(String content) {
        return content.replace("*", "");
    }

    public static SymbolsModel buildStructureTree(List<Either<SymbolInformation, DocumentSymbol>> infos, URI uri) {
        SymbolsModel symbolsModel = new SymbolsModel();
        symbolsModel.setUri(URI.create("test://test"));
        symbolsModel.update(infos);
        return symbolsModel;
    }

    public static JSONObject dumpStructureToJSON(SymbolsModel tree, TextDocumentIdentifier id) {
        JSONObject object = new JSONObject();
        List<DocumentSymbol> elements = Arrays.asList(tree.getElements()).stream().filter(obj -> obj instanceof SymbolsModel.DocumentSymbolWithFile).map(obj -> ((SymbolsModel.DocumentSymbolWithFile)obj).symbol).collect(Collectors.toList());
        JSONArray result = new JSONArray();
        object.put("jsonrpc", (Object)"2.0");
        object.put("id", (Object)"2");
        object.put(RESULT, (Object)result);
        elements.forEach(item -> {
            JSONArray jSONArray2 = result.put((Object)TestUtils.dumpStructureToJSON(tree, item, id));
        });
        return object;
    }

    private static JSONObject dumpStructureToJSON(SymbolsModel tree, DocumentSymbol item, TextDocumentIdentifier id) {
        JSONObject object = new JSONObject();
        JSONArray array = new JSONArray();
        object.put(NAME, (Object)item.getName());
        object.put(KIND, item.getKind().getValue());
        JSONObject range = new JSONObject();
        object.put(RANGE, (Object)range);
        JSONObject start = new JSONObject();
        start.put(LINE, item.getRange().getStart().getLine());
        start.put(CHARACTER, item.getRange().getStart().getCharacter());
        range.put(START, (Object)start);
        JSONObject end = new JSONObject();
        end.put(LINE, item.getRange().getEnd().getLine());
        end.put(CHARACTER, item.getRange().getEnd().getCharacter());
        range.put("end", (Object)end);
        range = new JSONObject();
        object.put(SELECTION_RANGE, (Object)range);
        start = new JSONObject();
        start.put(LINE, item.getSelectionRange().getStart().getLine());
        start.put(CHARACTER, item.getSelectionRange().getStart().getCharacter());
        range.put(START, (Object)start);
        end = new JSONObject();
        end.put(LINE, item.getSelectionRange().getEnd().getLine());
        end.put(CHARACTER, item.getSelectionRange().getEnd().getCharacter());
        range.put("end", (Object)end);
        object.put(DEPRECATED, (Object)item.getDeprecated());
        object.put("detail", (Object)item.getDetail());
        object.put(CHILDREN, (Object)array);
        if (!item.getChildren().isEmpty()) {
            item.getChildren().forEach(it -> {
                JSONArray jSONArray2 = array.put((Object)TestUtils.dumpStructureToJSON(tree, it, id));
            });
        }
        return object;
    }

    public static void compareStructureRoot(JSONObject expected, JSONObject actually, String testName) {
        expected.keySet().forEach(key -> {
            JSONArray ch1 = expected.has(RESULT) ? expected.getJSONArray(RESULT) : new JSONArray();
            JSONArray ch2 = actually.has(RESULT) ? actually.getJSONArray(RESULT) : new JSONArray();
            TestUtils.compareArrays(ch1, ch2, "", testName);
        });
    }

    private static void compareItem(JSONObject expected, JSONObject actually, String parentName, String testName) {
        JSONArray ch1 = expected.has(CHILDREN) ? expected.getJSONArray(CHILDREN) : new JSONArray();
        JSONArray ch2 = actually.has(CHILDREN) ? actually.getJSONArray(CHILDREN) : new JSONArray();
        TestUtils.compareArrays(ch1, ch2, parentName, testName);
    }

    private static void compareArrays(JSONArray expected, JSONArray actually, String parentName, String testName) {
        Assert.assertEquals((String)("children length of '" + parentName + "' should be equal"), (long)expected.length(), (long)actually.length());
        ArrayList<JSONObject> l1 = new ArrayList<JSONObject>();
        ArrayList<JSONObject> l2 = new ArrayList<JSONObject>();
        int i = 0;
        while (i < expected.length()) {
            JSONObject exp = expected.getJSONObject(i);
            l1.add(exp);
            JSONObject similar = null;
            boolean found = false;
            int j = 0;
            while (j < actually.length()) {
                JSONObject obj = actually.getJSONObject(j);
                if (exp.optString(NAME).equals(obj.optString(NAME))) {
                    similar = obj;
                }
                if (TestUtils.isEqualItems(exp, obj)) {
                    similar = obj;
                    l2.add(obj);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                System.out.println("NOT FOUND FOR \n" + (exp != null ? exp.toString(2) : "<null>"));
                Assert.assertEquals((String)testName, (Object)TestUtils.asString(exp), (Object)TestUtils.asString(similar));
            }
            ++i;
        }
        Assert.assertEquals((String)("children of '" + parentName + "' should be equal"), (long)l1.size(), (long)l2.size());
        i = 0;
        while (i < expected.length()) {
            TestUtils.compareItem((JSONObject)l1.get(i), (JSONObject)l2.get(i), ((JSONObject)l1.get(i)).optString(NAME), testName);
            ++i;
        }
    }

    public static String asString(JSONObject item) {
        if (item == null) {
            return null;
        }
        return item.toString(2);
    }

    private static boolean isEqualItems(JSONObject expected, JSONObject actually) {
        if (!expected.getString(NAME).equals(actually.getString(NAME))) {
            return false;
        }
        if (expected.getBoolean(DEPRECATED) != actually.getBoolean(DEPRECATED)) {
            return false;
        }
        if (expected.getInt(KIND) != actually.getInt(KIND)) {
            return false;
        }
        if (!TestUtils.isRangeEqual(RANGE, expected, actually)) {
            return false;
        }
        return TestUtils.isRangeEqual(SELECTION_RANGE, expected, actually);
    }

    private static boolean isRangeEqual(String rangeName, JSONObject expected, JSONObject actually) {
        JSONObject rangeExpected = expected.getJSONObject(rangeName);
        if (!actually.has(rangeName)) {
            return false;
        }
        JSONObject rangeActual = actually.getJSONObject(rangeName);
        if (!rangeActual.has(START)) {
            return false;
        }
        JSONObject rangeActualStart = rangeActual.getJSONObject(START);
        if (!rangeActualStart.has(LINE) || rangeActualStart.getInt(LINE) != rangeExpected.getJSONObject(START).getInt(LINE)) {
            return false;
        }
        if (!rangeActualStart.has(CHARACTER) || rangeActualStart.getInt(CHARACTER) != rangeExpected.getJSONObject(START).getInt(CHARACTER)) {
            return false;
        }
        JSONObject rangeActualEnd = rangeActual.getJSONObject("end");
        if (!rangeActualEnd.has(LINE) || rangeActualEnd.getInt(LINE) != rangeExpected.getJSONObject("end").getInt(LINE)) {
            return false;
        }
        return rangeActualEnd.has(CHARACTER) && rangeActualEnd.getInt(CHARACTER) == rangeExpected.getJSONObject("end").getInt(CHARACTER);
    }

    public static String patchUriString(String uri) {
        return uri.startsWith("file:/") ? uri.replaceFirst("file:(/)+", "file:///") : "file://" + uri;
    }

    public static String patchUri(URI uri) {
        String uriString = uri.toString();
        return uriString.startsWith("file:/") ? uriString.replaceFirst("file:(/)+", "file:///") : "file://" + String.valueOf(uri);
    }

    public static boolean isWindows() {
        return OS_NAME.contains("win");
    }

    public static URI getURI(String filepath) {
        File file = new File(filepath);
        return file.toURI();
    }

    public static URI resolvedURI(String filepath) {
        return TestUtils.getURI("src/test/resources/" + filepath);
    }

    public static String locationToString(Location location) {
        return location.getRange().getStart().getLine() + ", " + location.getRange().getStart().getCharacter() + ", " + location.getRange().getEnd().getLine() + ", " + location.getRange().getEnd().getCharacter();
    }

    public static void assertTiming(TelemetryManager telemetryManager, String uriString, long timeLimit, TimeUnit unit) {
        if (timeLimit == 0L) {
            return;
        }
        Long timing = (Long)telemetryManager.getTimings().get(uriString);
        if (timing != null) {
            Long convertedTiming = unit.convert(timing, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)String.format("Processing time %d of %s below required limit (%d)", convertedTiming, uriString, timeLimit), (convertedTiming < timeLimit ? 1 : 0) != 0);
        }
    }

    public static void assertTelemetry(TestTelemetryManager telemetryManager, String id, long timeLimit, TimeUnit unit, TelemetryMessageTypes messageType, Wrapper<Long> time) {
        TelemetryEvent actual = null;
        try {
            actual = telemetryManager.tryGetEvent(id, timeLimit, messageType, true);
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
            Thread.currentThread().interrupt();
        }
        Assert.assertNotNull((String)String.format("Telemetry %s event should happen for %s, but was null", messageType.name(), id), (Object)actual);
        if (actual != null) {
            Long convertedTiming = unit.convert(actual.getTime(), TimeUnit.MILLISECONDS);
            if (time != null) {
                time.setObject(convertedTiming);
            }
            Assert.assertTrue((String)String.format("Processing time %d of %s for %s below required limit (%d)", convertedTiming, messageType.name(), id, timeLimit), (convertedTiming < timeLimit ? 1 : 0) != 0);
        }
    }

    private static String addToCurrentLine(List<String> list, String toAdd) {
        return list.set(list.size() - 1, list.get(list.size() - 1).concat(toAdd));
    }

    public static Map<Position, List<String>> parseSuggestionFile(URI suggestionFileURI, boolean rewriteExpected) throws IOException {
        HashMap<Position, List<String>> proposalItems = null;
        File proposalItemsFile = new File(suggestionFileURI);
        ArrayList<String> proposalItemsLines = new ArrayList<String>();
        if (proposalItemsFile.exists()) {
            List<String> lineList = Files.readAllLines(proposalItemsFile.toPath(), Charset.defaultCharset());
            for (String line : lineList) {
                if (line != null && line.matches("\\d+:\\d+\\s-\\s.*")) {
                    if (proposalItemsLines.size() > 0) {
                        TestUtils.addToCurrentLine(proposalItemsLines, "\n");
                    }
                    proposalItemsLines.add(line);
                    continue;
                }
                if (line == null) continue;
                TestUtils.addToCurrentLine(proposalItemsLines, "\n");
                TestUtils.addToCurrentLine(proposalItemsLines, line);
            }
        }
        proposalItems = new HashMap<Position, List<String>>();
        if (rewriteExpected && proposalItemsLines.isEmpty()) {
            proposalItemsLines.add("4:0 - dummy");
        }
        for (String line : proposalItemsLines) {
            Pattern p = Pattern.compile("(\\d+:\\d+)\\s-\\s(.*)", 40);
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            String[] positionStrings = m.group(1).split(":");
            Position position = new Position(Integer.parseInt(positionStrings[0].trim()), Integer.parseInt(positionStrings[1].trim()));
            String proposalsAsString = m.group(2);
            ArrayList<String> proposals = new ArrayList<String>();
            proposals.addAll(Arrays.asList(proposalsAsString.split(";")));
            proposalItems.put(position, proposals);
        }
        return proposalItems;
    }

    public static class Wrapper<T> {
        private T object;

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }
    }
}

