/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.mule.alsp.telemetry.TelemetryEvent;
import org.mule.alsp.telemetry.TelemetryManager;
import org.mule.alsp.telemetry.TelemetryMessageTypes;
import org.mule.alsp.testapi.TestApi;

public class TestTelemetryManager
extends TelemetryManager {
    private final Map<String, BlockingQueue<TelemetryEvent>> endEvents = new ConcurrentHashMap<String, BlockingQueue<TelemetryEvent>>();
    private static final ThreadLocal<Boolean> threadsafeTimingsEnabled = new ThreadLocal();
    private static final ThreadLocal<Boolean> threadsafeTelemetryEnabled = new ThreadLocal();

    public TestTelemetryManager() {
        super(null);
        this.eventProcessor = event -> {
            if (TestApi.isVerbose()) {
                System.out.println("Processing " + event.getMessageType().name() + " for " + event.getUri());
            }
            if (!this.endEvents.containsKey(event.key())) {
                LinkedBlockingQueue queue = new LinkedBlockingQueue();
                this.endEvents.put(event.key(), queue);
            }
            this.endEvents.get(event.key()).add(event);
            this.endEvents.get(event.key()).notifyAll();
            if (TestApi.isVerbose()) {
                System.out.println("Processed " + event.getMessageType().name() + " for " + event.getUri());
            }
            return true;
        };
        this.setTimingsEnabled(super.isTimingsEnabled());
        this.setTelemetryEnabled(super.isTelemetryEnabled());
    }

    public Map<String, BlockingQueue<TelemetryEvent>> getEvents() {
        return this.endEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TelemetryEvent tryGetEvent(String id, long timeLimit, TelemetryMessageTypes messageType, boolean poll) throws InterruptedException {
        TelemetryEvent expected = new TelemetryEvent();
        expected.setUri(id);
        expected.setMessageType(messageType);
        String key = expected.key();
        Map<String, BlockingQueue<TelemetryEvent>> events = this.getEvents();
        if (!events.containsKey(key)) {
            events.put(key, new LinkedBlockingQueue());
        }
        TelemetryEvent actual = null;
        BlockingQueue<TelemetryEvent> queue = events.get(expected.key());
        if (poll) {
            actual = queue.poll(Math.max(5000L, timeLimit + 5000L), TimeUnit.MILLISECONDS);
        } else {
            BlockingQueue<TelemetryEvent> blockingQueue = queue;
            synchronized (blockingQueue) {
                queue.wait(Math.max(5000L, timeLimit + 5000L));
            }
            actual = (TelemetryEvent)queue.peek();
        }
        return actual;
    }

    public void setTimingsEnabled(boolean timingsEnabled) {
        threadsafeTimingsEnabled.set(timingsEnabled);
        super.setTimingsEnabled(timingsEnabled);
    }

    public boolean isTimingsEnabled() {
        Boolean is = threadsafeTimingsEnabled.get();
        return is != null ? is : false;
    }

    public boolean isTelemetryEnabled() {
        Boolean is = threadsafeTelemetryEnabled.get();
        return is != null ? is : false;
    }

    public void setTelemetryEnabled(boolean telemetryEnabled) {
        threadsafeTelemetryEnabled.set(telemetryEnabled);
        super.setTelemetryEnabled(telemetryEnabled);
    }

    public void removeTimingsEnabled() {
        threadsafeTimingsEnabled.remove();
    }

    public void removeTelemetryEnabled() {
        threadsafeTelemetryEnabled.remove();
    }
}

