/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.connection.ALSPAsyncSocketConnectionProvider;
import org.mule.alsp.connection.ALSPSocketConnectionProvider;
import org.mule.alsp.testapi.TestTelemetryManager;
import org.mule.alsp.testapi.lsp.LanguageServerProxy;
import org.mule.alsp.testapi.lsp.TestLanguageClient;
import org.mule.alsp.testapi.params.StructureTestPrams;
import org.mule.alsp.testapi.params.SuggestionTestParams;
import org.mule.alsp.testapi.params.TestParams;
import org.mule.alsp.testapi.params.ValidationTestParams;
import org.mule.alsp.testapi.strategies.ITestStrategy;
import org.mule.alsp.testapi.strategies.ManageDocumentStrategy;
import org.mule.alsp.testapi.strategies.StructureTestStrategy;
import org.mule.alsp.testapi.strategies.SuggestionTestStrategy;
import org.mule.alsp.testapi.strategies.ValidationTestStrategy;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class TestApi {
    public static final String ROOT_DIR = "src/test/resources/";
    private static final TestTelemetryManager telemetryManager = new TestTelemetryManager();
    private static final ThreadLocal<List<TestParams>> currentInocationParams = new ThreadLocal();
    private static boolean verbose = true;
    private final LanguageServerProxy serverProxy;
    private final Map<Class<? extends TestParams>, ITestStrategy<? extends TestParams>> strategies = new HashMap<Class<? extends TestParams>, ITestStrategy<? extends TestParams>>();
    private StreamConnectionProvider streamProvider = null;
    private ManageDocumentStrategy manageDocument;
    private PrintWriter logWriter;

    static {
        try {
            new ALSPlugin().start(new BundleContext(){

                public boolean ungetService(ServiceReference<?> reference) {
                    return false;
                }

                public void removeServiceListener(ServiceListener listener) {
                }

                public void removeFrameworkListener(FrameworkListener listener) {
                }

                public void removeBundleListener(BundleListener listener) {
                }

                public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
                    return null;
                }

                public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
                    return null;
                }

                public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
                    return null;
                }

                public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
                    return null;
                }

                public Bundle installBundle(String location, InputStream input) throws BundleException {
                    return null;
                }

                public Bundle installBundle(String location) throws BundleException {
                    return null;
                }

                public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
                    return null;
                }

                public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
                    return null;
                }

                public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
                    return null;
                }

                public ServiceReference<?> getServiceReference(String clazz) {
                    return null;
                }

                public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> reference) {
                    return null;
                }

                public <S> S getService(ServiceReference<S> reference) {
                    return null;
                }

                public String getProperty(String key) {
                    return null;
                }

                public File getDataFile(String filename) {
                    return null;
                }

                public Bundle[] getBundles() {
                    return null;
                }

                public Bundle getBundle(String location) {
                    return null;
                }

                public Bundle getBundle(long id) {
                    return null;
                }

                public Bundle getBundle() {
                    return null;
                }

                public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
                    return null;
                }

                public Filter createFilter(String filter) throws InvalidSyntaxException {
                    return null;
                }

                public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
                }

                public void addServiceListener(ServiceListener listener) {
                }

                public void addFrameworkListener(FrameworkListener listener) {
                }

                public void addBundleListener(BundleListener listener) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TestApi() {
        this(new ALSPAsyncSocketConnectionProvider());
        Logger.getGlobal().setLevel(Level.FINE);
        ALSPlugin.isALSTelemetryEnabled();
        ALSPlugin.isTelemetryEnabled();
    }

    public TestApi(ALSPSocketConnectionProvider streamProvider) {
        this.getSilentMode();
        ALSPlugin.getDefault().setAlsInitialized(true);
        Launcher<LanguageServer> launcher = this.getServerProxy(streamProvider, this.logWriter, false);
        this.serverProxy = new LanguageServerProxy((LanguageServer)launcher.getRemoteProxy(), telemetryManager);
        this.initliazeStrategies();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    public TestApi(ALSPAsyncSocketConnectionProvider streamProvider) {
        this.getSilentMode();
        ALSPlugin.getDefault().setAlsInitialized(true);
        Launcher<LanguageServer> launcher = this.getServerProxy(streamProvider, this.logWriter, false);
        this.serverProxy = new LanguageServerProxy((LanguageServer)launcher.getRemoteProxy(), telemetryManager);
        this.initliazeStrategies();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    public static TestTelemetryManager getTelemetryManager() {
        return telemetryManager;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void addInvocation(TestParams params) {
        if (params.getUri() == null) {
            return;
        }
        if (currentInocationParams.get() == null) {
            currentInocationParams.set(new ArrayList());
        }
        currentInocationParams.get().add(params);
    }

    public static List<TestParams> takeInvocations() {
        return currentInocationParams.get();
    }

    public static void incorrectCleanup() {
        currentInocationParams.remove();
    }

    public static boolean isTelemetryEnabled() {
        return TestApi.getTelemetryManager().isTelemetryEnabled();
    }

    public static void setTelemetryEnabled(boolean telemetryEnabled) {
        TestApi.getTelemetryManager().setTelemetryEnabled(telemetryEnabled);
    }

    public static boolean isTimingsEnabled() {
        return TestApi.getTelemetryManager().isTimingsEnabled();
    }

    public static void setTimingsEnabled(boolean timingsEnabled) {
        TestApi.getTelemetryManager().setTimingsEnabled(timingsEnabled);
    }

    public Launcher<LanguageServer> getServerProxy(ALSPSocketConnectionProvider streamProvider, PrintWriter logWriter, boolean verbose) {
        TestLanguageClient clientImpl = this.initializeStreamProvider((StreamConnectionProvider)streamProvider, verbose);
        Launcher launcher = LSPLauncher.createClientLauncher((LanguageClient)clientImpl, (InputStream)streamProvider.getInputStream(), (OutputStream)streamProvider.getOutputStream(), (boolean)false, (PrintWriter)logWriter);
        launcher.startListening();
        this.getLauncher((Launcher<LanguageServer>)launcher);
        return launcher;
    }

    private Launcher<LanguageServer> getServerProxy(ALSPAsyncSocketConnectionProvider streamProvider, PrintWriter logWriter, boolean verbose) {
        TestLanguageClient clientImpl = this.initializeStreamProvider((StreamConnectionProvider)streamProvider, verbose);
        Launcher launcher = LSPLauncher.createClientLauncher((LanguageClient)clientImpl, (InputStream)streamProvider.getInputStream(), (OutputStream)streamProvider.getOutputStream(), (boolean)false, (PrintWriter)logWriter);
        launcher.startListening();
        this.getLauncher((Launcher<LanguageServer>)launcher);
        return launcher;
    }

    public void close() {
        ManageDocumentStrategy.getConcurrentactivitiesforfile().clear();
        this.serverProxy.shutdown();
        if (this.streamProvider instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.streamProvider).close();
                ((AutoCloseable)this.streamProvider).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void openDocument(URI uri, String content) {
        this.manageDocument.openDocument(uri, content);
    }

    public <T extends TestParams> void test(T params) {
        ITestStrategy<? extends TestParams> stategy = this.strategies.get(params.getClass());
        this.test(stategy, params);
    }

    public <T extends TestParams> void test(ITestStrategy<T> strategy, T params) {
        params.setTestStrategy(strategy);
        TestApi.addInvocation(params);
        strategy.test(params);
    }

    public <T extends TestParams> void cleanup(T params) {
        if (params != null) {
            ITestStrategy<? extends TestParams> strategy = this.strategies.get(params.getClass());
            strategy.cleanup(params);
        }
    }

    public void structureTest(URI uri, URI jsonUri, String testName, boolean rewriteExpected) {
        StructureTestPrams params = TestParams.createStructureTestParams(uri, jsonUri, testName, this.checkForGlobalRewrite(rewriteExpected));
        this.test(params);
    }

    public void suggestionsTest(URI uri, URI proposalsFileURI, List<String> proposalItems, String testName, boolean rewriteExpected) {
        SuggestionTestParams params = TestParams.createSuggestionTestParams(uri, proposalsFileURI, proposalItems, testName, this.checkForGlobalRewrite(rewriteExpected));
        this.test(params);
    }

    public void validationTest(URI uri, URI errorsFileURI, List<String> validationIssues, String testName, boolean rewriteExpected) {
        ValidationTestParams params = TestParams.createValidationTestParams(uri, errorsFileURI, validationIssues, testName, this.checkForGlobalRewrite(rewriteExpected));
        this.test(params);
    }

    private void getSilentMode() {
        String silent = System.getenv("SILENT_ALS");
        silent = System.getProperty("SILENT_ALS");
        if (silent == null || !"true".equalsIgnoreCase(silent)) {
            this.logWriter = new PrintWriter(System.out);
            System.out.println("\n\n\n************************ NOT SILENT *************\n\n\n");
            verbose = true;
        } else {
            System.out.println("\n\n\n************************ SILENT *************\n\n\n");
            verbose = false;
            this.logWriter = null;
        }
    }

    private TestLanguageClient initializeStreamProvider(StreamConnectionProvider streamProvider, boolean verbose) {
        TestLanguageClient clientImpl = new TestLanguageClient(telemetryManager);
        try {
            this.streamProvider = streamProvider;
            this.streamProvider.getErrorStream();
            this.streamProvider.equals(streamProvider);
            this.streamProvider.equals(this.streamProvider);
            this.streamProvider.equals(null);
            if (streamProvider instanceof ALSPSocketConnectionProvider) {
                ((ALSPSocketConnectionProvider)streamProvider).getTextDocumentService();
                ((ALSPSocketConnectionProvider)streamProvider).setVerbose(verbose);
            }
            streamProvider.start();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return clientImpl;
    }

    private void getLauncher(Launcher<LanguageServer> launcher) {
        InitializeParams initParams = new InitializeParams();
        try {
            ((LanguageServer)launcher.getRemoteProxy()).initialize(initParams).get(5L, TimeUnit.SECONDS);
            Thread.sleep(100L);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    private void initliazeStrategies() {
        this.manageDocument = new ManageDocumentStrategy(this.serverProxy);
        this.strategies.put(SuggestionTestParams.class, new SuggestionTestStrategy(this.serverProxy));
        this.strategies.put(StructureTestPrams.class, new StructureTestStrategy(this.serverProxy));
        this.strategies.put(ValidationTestParams.class, new ValidationTestStrategy(this.serverProxy, this.serverProxy.getTextDocumentService()));
    }

    public void warmup() {
        try {
            File temp = new File("src/test/resources/suggestions/test_00.raml");
            boolean enabled = TestApi.isTelemetryEnabled();
            boolean timingEnabled = TestApi.isTimingsEnabled();
            TestApi.setTelemetryEnabled(false);
            TestApi.setTimingsEnabled(false);
            this.suggestionsTest(temp.toURI(), null, new ArrayList<String>(), "", false);
            TestApi.setTelemetryEnabled(enabled);
            TestApi.setTelemetryEnabled(timingEnabled);
        }
        catch (Throwable throwable) {}
        try {
            Thread.sleep(1000L);
            System.out.println("\n\n##############\n\nFinished Warmup\n\n##############\n\n");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    public ManageDocumentStrategy getManageDocument() {
        return this.manageDocument;
    }

    public void setManageDocument(ManageDocumentStrategy manageDocument) {
        this.manageDocument = manageDocument;
    }

    private Boolean checkForGlobalRewrite(boolean defaultRewrite) {
        String envRewrite = System.getenv("APIEDITOR_REWRITE_TESTS");
        if (StringUtils.isNotBlank((CharSequence)envRewrite)) {
            return Boolean.valueOf(envRewrite);
        }
        String propertyRewrite = System.getProperty("apieditor.rewrite.tests");
        if (StringUtils.isNotBlank((CharSequence)propertyRewrite)) {
            return Boolean.valueOf(propertyRewrite);
        }
        return defaultRewrite;
    }

    public LanguageServerProxy getLanguageServerProxy() {
        return this.serverProxy;
    }
}

