/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.mule.alsp.helpers.LSUtils;
import org.mule.alsp.testapi.TestJarRoot;

public class JarUtils {
    public static JarEntryFile createJarEntry(String jarFile, String fileInJar) {
        JarEntryFile jarEntry = new JarEntryFile(fileInJar);
        TestJarRoot root = new TestJarRoot((IPath)new Path(new File(jarFile).getAbsolutePath()), null);
        jarEntry.setParent((Object)root);
        return jarEntry;
    }

    public static URI create(String jarPath, String fileInJarPath, String body) throws IOException {
        java.nio.file.Path rootPath = Paths.get(jarPath, new String[0]).getParent();
        File dir = Files.createTempDirectory(rootPath, "jar", new FileAttribute[0]).toFile();
        File raml = new File(dir, fileInJarPath);
        if (raml.exists()) {
            raml.delete();
        }
        raml.createNewFile();
        FileUtils.write((File)raml, (CharSequence)body, (Charset)Charset.defaultCharset());
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(jarPath), manifest);
        JarUtils.add(dir, dir, target);
        target.close();
        FileUtils.deleteDirectory((File)dir);
        return LSUtils.createArchiveURI((String)jarPath, (String)fileInJarPath, (boolean)false);
    }

    private static void add(File source, File rootDir, JarOutputStream target) throws IOException {
        try (BufferedInputStream in = null;){
            int count;
            if (source.isDirectory()) {
                Object name = source.getPath().replace("\\", "/");
                if (!((String)name).isEmpty() && source.compareTo(rootDir) != 0) {
                    if (!((String)name).endsWith("/")) {
                        name = (String)name + "/";
                    }
                    JarEntry entry = new JarEntry((String)name);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                File[] fileArray = source.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File nestedFile = fileArray[n2];
                    JarUtils.add(nestedFile, rootDir, target);
                    ++n2;
                }
                return;
            }
            JarEntry entry = new JarEntry(rootDir.toPath().relativize(source.toPath()).toFile().toString().replace("\\", "/"));
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
    }
}

