/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.testapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.runners.Parameterized;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;

public abstract class BaseMultiTest {
    private static final int columnCount = 6;
    private static final FilenameFilter ramlFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".raml");
        }
    };
    protected static TestApi api;
    protected static BaseMultiTest INSTANCE;
    protected static final char IGNORED_TESTS_SEPARATOR = ',';
    @Parameterized.Parameter(value=0)
    public String folderName;
    @Parameterized.Parameter(value=1)
    public String ramlFileName;
    @Parameterized.Parameter(value=2)
    public String ignoredTests;
    @Parameterized.Parameter(value=3)
    public String outlineFileName;
    @Parameterized.Parameter(value=4)
    public String errorsFileName;
    @Parameterized.Parameter(value=5)
    public String suggestionsFileName;

    protected BaseMultiTest() {
        INSTANCE = this;
    }

    protected static BaseMultiTest getInstance() {
        return INSTANCE;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static Collection<String[]> data() {
        System.out.println(Paths.get("", new String[0]).toAbsolutePath().toString());
        recordsResolved = new ArrayList<String[]>();
        records = null;
        records = "true".equalsIgnoreCase(System.getenv("SCAN_ALL_FOLDERS")) != false ? Arrays.asList(BaseMultiTest.listAllTestFolders()).stream().map((Function<File, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(java.io.File ), (Ljava/io/File;)[Ljava/lang/String;)()).collect(Collectors.toList()) : BaseMultiTest.getInstance().readTestsConfiguration("testsConfiguration.csv");
        header = null;
        if (records.get(0)[0].toString().startsWith("#")) {
            header = (String[])records.get(0);
            records.remove(0);
        } else {
            header = new String[6];
        }
        recordsToRemove = new ArrayList<String[]>();
        for (String[] var4_5 : records) {
            if (!var4_5[0].startsWith("#")) continue;
            recordsToRemove.add(var4_5);
        }
        records.removeAll(recordsToRemove);
        for (String[] var4_7 : records) {
            block6: {
                if (var4_7.length >= header.length && var4_7[1] != null && !var4_7[1].toString().isEmpty()) break block6;
                folder = new File(TestUtils.resolvedURI(BaseMultiTest.getInstance().getPackageDirectory() + var4_7[0].toString()));
                var11_13 = ramls = folder.listFiles(BaseMultiTest.ramlFileFilter);
                var10_12 = ramls.length;
                var9_11 = 0;
                if (true) ** GOTO lbl49
            }
            var4_7[1] = var4_7[0] + "/" + var4_7[1];
            var4_7[2] = BaseMultiTest.normalizeIgnoredTests(var4_7[2]);
            var4_7[3] = var4_7[0] + "/test-expected/" + var4_7[1] + "_outline.json";
            var4_7[4] = var4_7[0] + "/test-expected/" + var4_7[1] + "_errors.csv";
            var4_7[5] = var4_7[0] + "/test-expected/" + var4_7[1] + "_suggestions.csv";
            recordsResolved.add(var4_7);
            continue;
            do {
                raml = var11_13[var9_11];
                newRecord = new String[header.length];
                newRecord[0] = var4_7[0];
                newRecord[1] = var4_7[0] + "/" + raml.getName();
                newRecord[2] = var4_7.length >= 3 ? BaseMultiTest.normalizeIgnoredTests(var4_7[2]) : "";
                newRecord[3] = var4_7[0] + "/test-expected/" + raml.getName() + "_outline.json";
                newRecord[4] = var4_7[0] + "/test-expected/" + raml.getName() + "_errors.csv";
                newRecord[5] = var4_7[0] + "/test-expected/" + raml.getName() + "_suggestions.csv";
                if (var4_7.length < 2 || StringUtils.isEmpty((CharSequence)var4_7[1]) || raml.getName().equals(var4_7[1])) {
                    recordsResolved.add(newRecord);
                }
                ++var9_11;
lbl49:
                // 2 sources

            } while (var9_11 < var10_12);
        }
        recordsResolved.sort(new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                int result = 0;
                result = o1[0].compareTo(o1[0]);
                return result != 0 ? result : o1[1].compareTo(o2[1]);
            }
        });
        return recordsResolved;
    }

    private static String normalizeIgnoredTests(String ignoredTests) {
        if (StringUtils.isBlank((CharSequence)ignoredTests)) {
            return ignoredTests;
        }
        List trimmedTags = Arrays.stream(StringUtils.split((String)ignoredTests, (char)',')).map(String::trim).collect(Collectors.toList());
        return StringUtils.join(trimmedTags, (char)',');
    }

    private static File[] listAllTestFolders() {
        File[] folders = new File("src/test/resources/").listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.listFiles(ramlFileFilter).length > 0;
            }
        });
        return folders;
    }

    public String getPackageDirectory() {
        String name = this.getClass().getSimpleName();
        String fullName = this.getClass().getName();
        return fullName.replace("." + name, "").replaceAll("\\.", "/") + "/";
    }

    private List<String[]> readTestsConfiguration(String filename) {
        ArrayList<String[]> records = new ArrayList<String[]>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(new File(TestUtils.resolvedURI(this.getPackageDirectory() + filename))));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] values = line.split(";");
                    records.add(values);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return records;
    }

    public void suggestionsTest(String testName, boolean rewriteExpected) throws IOException {
        URI proposalsFileURI = TestUtils.resolvedURI(BaseMultiTest.getInstance().getPackageDirectory() + this.suggestionsFileName);
        URI uri = TestUtils.resolvedURI(BaseMultiTest.getInstance().getPackageDirectory() + this.ramlFileName);
        api.suggestionsTest(uri, proposalsFileURI, null, testName, false);
    }
}

