/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.test.publicapis;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;
import org.junit.runners.model.InitializationError;
import org.junit.runners.parameterized.ParametersRunnerFactory;
import org.junit.runners.parameterized.TestWithParameters;
import org.mule.alsp.telemetry.TelemetryType;
import org.mule.alsp.testapi.BaseMultiTest;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.performance.IgnoreParameterized;
import org.mule.alsp.testapi.performance.ParametrizedPerformance;
import org.mule.alsp.testapi.performance.PerformanceRunnerWithParameters;
import org.mule.alsp.testapi.performance.TimingTest;
import org.mule.alsp.testapi.performance.TimingTestValue;
import org.mule.alsp.testapi.performance.UsePerformanceRunnerConfiguration;
import org.mule.alsp.testapi.strategies.ManageDocumentStrategy;

@RunWith(value=ParametrizedPerformance.class)
@Parameterized.UseParametersRunnerFactory(value=RunnerFactory.class)
@UsePerformanceRunnerConfiguration(threads=3)
@TimingTest(value=5000L)
public class SimpleMultiTest
extends BaseMultiTest {
    static {
        new SimpleMultiTest();
    }

    @Parameterized.Parameters(name="{index} - {1}")
    public static Collection<String[]> data() {
        return BaseMultiTest.data();
    }

    @BeforeClass
    public static void initTest() throws IOException {
        api = new TestApi();
        ManageDocumentStrategy.getConcurrentactivitiesforfile().clear();
    }

    @AfterClass
    public static void cleanupTest() throws IOException {
        api.close();
        api = null;
        ManageDocumentStrategy.getConcurrentactivitiesforfile().clear();
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=3000L), @TimingTest(value=4000L, name="github-api-1.0.0-raml/api.raml"), @TimingTest(value=5000L, name="zendesk-api-1.0.0-raml/api.raml"), @TimingTest(value=1000L, telemetryEvent=TelemetryType.COMPLETION, name=""), @TimingTest(value=2500L, telemetryEvent=TelemetryType.COMPLETION, name="account-aggregation-process-api-2.0.0-raml/banking_accounts_process_api.raml"), @TimingTest(value=1900L, telemetryEvent=TelemetryType.COMPLETION, name="box-api-1.0.0-raml/api.raml"), @TimingTest(value=3000L, telemetryEvent=TelemetryType.COMPLETION, name="catalyst-retail-omnichannel-xp-api-2.0.3-raml/api.raml"), @TimingTest(value=2000L, telemetryEvent=TelemetryType.COMPLETION, name="crm-fhir-system-api-2.0.1-raml/healthcare_sfhc2fhir_system_api.raml"), @TimingTest(value=1100L, telemetryEvent=TelemetryType.COMPLETION, name="fhir-apis-2.0.0-raml/fhir_api.raml"), @TimingTest(value=3900L, telemetryEvent=TelemetryType.COMPLETION, name="github-api-1.0.0-raml/api.raml"), @TimingTest(value=2000L, telemetryEvent=TelemetryType.COMPLETION, name="google-drive-api-1.0.0-raml/api.raml"), @TimingTest(value=1600L, telemetryEvent=TelemetryType.COMPLETION, name="stibo-api-1.0.0-raml/STEP REST API V2.raml"), @TimingTest(value=1300L, telemetryEvent=TelemetryType.COMPLETION, name="stripe-api-1.0.0-raml/api.raml"), @TimingTest(value=2300L, telemetryEvent=TelemetryType.COMPLETION, name="twitter-api-1.0.0-raml/api.raml"), @TimingTest(value=4700L, telemetryEvent=TelemetryType.COMPLETION, name="zendesk-api-1.0.0-raml/api.raml"), @TimingTest(value=1300L, telemetryEvent=TelemetryType.COMPLETION, name="zuora-raml-1.0.0-raml/api.raml")})
    @IgnoreParameterized(tag="suggestions")
    public void suggestionTest() throws Exception {
        System.out.println(String.format("Testing %1$s - %2$s", this.folderName, this.ramlFileName));
        this.suggestionsTest(this.ramlFileName, false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=7000L), @TimingTest(value=3000L, telemetryEvent=TelemetryType.DIAGNOSTIC_PARSE, name=""), @TimingTest(value=5000L, telemetryEvent=TelemetryType.DIAGNOSTIC_PARSE, name="account-aggregation-process-api-2.0.0-raml/banking_accounts_process_api.raml"), @TimingTest(value=5000L, telemetryEvent=TelemetryType.DIAGNOSTIC_PARSE, name="crm-fhir-system-api-2.0.1-raml/healthcare_sfhc2fhir_system_api.raml"), @TimingTest(value=5000L, telemetryEvent=TelemetryType.DIAGNOSTIC_PARSE, name="fhir-apis-2.0.0-raml/fhir_api.raml"), @TimingTest(value=5000L, telemetryEvent=TelemetryType.DIAGNOSTIC_PARSE, name="salesforce-raml-1.0.0-raml/api.raml"), @TimingTest(value=1500L, telemetryEvent=TelemetryType.REPORT, name=""), @TimingTest(value=3000L, telemetryEvent=TelemetryType.REPORT, name="account-aggregation-process-api-2.0.0-raml/banking_accounts_process_api.raml"), @TimingTest(value=4000L, telemetryEvent=TelemetryType.REPORT, name="box-api-1.0.0-raml/api.raml"), @TimingTest(value=1100L, telemetryEvent=TelemetryType.REPORT, name="catalyst-healthcare-fitbit-sapi-2.0.1-raml/healthcare_fitbit2fhir_system_api.raml"), @TimingTest(value=600L, telemetryEvent=TelemetryType.REPORT, name="catalyst-healthcare-portal-api-2.0.0-raml/healthcare_portal_experience_api.raml"), @TimingTest(value=4200L, telemetryEvent=TelemetryType.REPORT, name="catalyst-retail-omnichannel-xp-api-2.0.3-raml/api.raml"), @TimingTest(value=9000L, telemetryEvent=TelemetryType.REPORT, name="crm-fhir-system-api-2.0.1-raml/healthcare_sfhc2fhir_system_api.raml"), @TimingTest(value=6300L, telemetryEvent=TelemetryType.REPORT, name="ehr-fhir-system-api-2.0.1-raml/healthcare_ehr2fhir_system_api.raml"), @TimingTest(value=5000L, telemetryEvent=TelemetryType.REPORT, name="fhir-apis-2.0.0-raml/fhir_api.raml"), @TimingTest(value=4500L, telemetryEvent=TelemetryType.REPORT, name="github-api-1.0.0-raml/api.raml"), @TimingTest(value=3000L, telemetryEvent=TelemetryType.REPORT, name="google-contacts-api-1.0.0-raml/api.raml"), @TimingTest(value=2000L, telemetryEvent=TelemetryType.REPORT, name="linkedin-api-1.0.0-raml/api.raml"), @TimingTest(value=1000L, telemetryEvent=TelemetryType.REPORT, name="mule-twilio-connector-3.0.0-raml/twilio-connector.raml"), @TimingTest(value=1300L, telemetryEvent=TelemetryType.REPORT, name="new-relic-api-2.0.3-raml/new-relic-api.raml"), @TimingTest(value=600L, telemetryEvent=TelemetryType.REPORT, name="qoppa-api-2.0.0-raml/qoppapdf.raml"), @TimingTest(value=5000L, telemetryEvent=TelemetryType.REPORT, name="salesforce-raml-1.0.0-raml/api.raml"), @TimingTest(value=1300L, telemetryEvent=TelemetryType.REPORT, name="stibo-api-1.0.0-raml/STEP REST API V2.raml"), @TimingTest(value=5000L, telemetryEvent=TelemetryType.REPORT, name="stripe-api-1.0.0-raml/api.raml"), @TimingTest(value=5000L, telemetryEvent=TelemetryType.REPORT, name="twitter-api-1.0.0-raml/api.raml"), @TimingTest(value=1200L, telemetryEvent=TelemetryType.REPORT, name="workiva-wdesk-spreadsheets-api-1.0.0-raml/workiva-wdesk-spreadsheets-api.raml"), @TimingTest(value=6000L, telemetryEvent=TelemetryType.REPORT, name="zendesk-api-1.0.0-raml/api.raml"), @TimingTest(value=2900L, telemetryEvent=TelemetryType.REPORT, name="zuora-raml-1.0.0-raml/api.raml")})
    @IgnoreParameterized(tag="errors")
    public void validationTest() throws IOException {
        System.out.println(String.format("Testing %1$s - %2$s  - %3$s", this.folderName, this.ramlFileName, this.errorsFileName));
        api.validationTest(TestUtils.resolvedURI(SimpleMultiTest.getInstance().getPackageDirectory() + this.ramlFileName), TestUtils.resolvedURI(SimpleMultiTest.getInstance().getPackageDirectory() + this.errorsFileName), null, this.ramlFileName, false);
    }

    @Test
    @IgnoreParameterized(tag="outline")
    public void outlineTest() throws InterruptedException, ExecutionException, IOException {
        System.out.println(String.format("Testing %1$s - %2$s", this.folderName, this.ramlFileName));
        api.structureTest(TestUtils.resolvedURI(SimpleMultiTest.getInstance().getPackageDirectory() + this.ramlFileName), TestUtils.resolvedURI(SimpleMultiTest.getInstance().getPackageDirectory() + this.outlineFileName), this.ramlFileName, false);
    }

    public boolean mustIgnoreParameterizedTest(String tag) {
        return StringUtils.isNotBlank((CharSequence)this.ignoredTests) && Arrays.asList(StringUtils.split((String)this.ignoredTests, (char)',')).contains(tag);
    }

    public static class RunnerFactory
    implements ParametersRunnerFactory {
        public Runner createRunnerForTestWithParameters(TestWithParameters test) throws InitializationError {
            return new PerformanceRunnerWithParameters(test);
        }
    }
}

