/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.test.performance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.params.TestParams;
import org.mule.alsp.testapi.strategies.ITestStrategy;

class SimultaneousFileTestStrategy
implements ITestStrategy<SimultaneousTestParams> {
    private final TestApi api;

    SimultaneousFileTestStrategy(TestApi api) {
        this.api = api;
    }

    @Override
    public void test(SimultaneousTestParams simulParams) {
        ExecutorService es = Executors.newFixedThreadPool(simulParams.testParamsList.size());
        ArrayList<Callable<Object>> todo = new ArrayList<Callable<Object>>(simulParams.testParamsList.size());
        boolean telemetryEnabled = TestApi.isTelemetryEnabled();
        for (TestParams testParams : simulParams.testParamsList) {
            TestApi.addInvocation(testParams);
            todo.add(Executors.callable(() -> {
                TestApi.setTelemetryEnabled(telemetryEnabled);
                this.api.test(testParams);
            }));
        }
        try {
            Thread.sleep(1000L);
            es.invokeAll(todo);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cleanup(SimultaneousTestParams simulParams) {
        for (TestParams testParams : simulParams.testParamsList) {
            this.api.cleanup(testParams);
        }
    }

    public class SimultaneousTestParams
    extends TestParams {
        final List<TestParams> testParamsList;

        public SimultaneousTestParams(TestParams ... ts) {
            this.testParamsList = new ArrayList<TestParams>(Arrays.asList(ts));
        }

        public List<TestParams> getTestParamsList() {
            return this.testParamsList;
        }
    }
}

