/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.test.performance;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mule.alsp.telemetry.TelemetryType;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.performance.PerformanceRunner;
import org.mule.alsp.testapi.performance.TimingTest;
import org.mule.alsp.testapi.performance.TimingTestValue;
import org.mule.alsp.testapi.performance.UsePerformanceRunnerConfiguration;

@RunWith(value=PerformanceRunner.class)
@UsePerformanceRunnerConfiguration(threads=1)
@TimingTest(value=200L)
@Ignore
public class PublicApiPerformanceTests {
    private static TestApi api = null;
    private static String silent = System.getProperty("SILENT_ALS", "false");

    @BeforeClass
    public static void startup() {
        System.setProperty("SILENT_ALS", "true");
        api = new TestApi();
        api.warmup();
    }

    @AfterClass
    public static void cleanup() {
        System.setProperty("SILENT_ALS", silent);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.PARSE, avgTime=200.0f), @TimingTest(value=5000L, telemetryEvent=TelemetryType.COMPLETION, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.REPORT, avgTime=200.0f)})
    public void suggestionTest01() {
        api.suggestionsTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/appian-api-1.0.5-raml/api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/appian-api-1.0.5-raml/test-expected/api.raml_suggestions.csv"), null, "suggestionTest01", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.STRUCTURE, avgTime=200.0f)})
    public void structureTest01() {
        api.structureTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/appian-api-1.0.5-raml/api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/appian-api-1.0.5-raml/test-expected/api.raml_outline.json"), "structureTest01", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.PARSE, avgTime=200.0f), @TimingTest(value=5000L, telemetryEvent=TelemetryType.COMPLETION, avgTime=200.0f), @TimingTest(value=7000L, telemetryEvent=TelemetryType.REPORT, avgTime=500.0f)})
    public void suggestionTest02() {
        api.suggestionsTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/fhir-apis-2.0.0-raml/fhir_api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/fhir-apis-2.0.0-raml/test-expected/fhir_api.raml_suggestions.csv"), null, "suggestionTest02", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.STRUCTURE, avgTime=200.0f)})
    public void structureTest02() {
        api.structureTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/fhir-apis-2.0.0-raml/fhir_api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/fhir-apis-2.0.0-raml/test-expected/fhir_api.raml_outline.json"), "suggestionTest02", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.PARSE, avgTime=200.0f), @TimingTest(value=5000L, telemetryEvent=TelemetryType.COMPLETION, avgTime=200.0f), @TimingTest(value=2500L, telemetryEvent=TelemetryType.REPORT, avgTime=200.0f)})
    public void suggestionTest03() {
        api.suggestionsTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/ehr-fhir-system-api-2.0.1-raml/healthcare_ehr2fhir_system_api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/ehr-fhir-system-api-2.0.1-raml/test-expected/healthcare_ehr2fhir_system_api.raml_suggestions.csv"), null, "suggestionTest03", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.STRUCTURE, avgTime=200.0f)})
    public void structureTest03() {
        api.structureTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/ehr-fhir-system-api-2.0.1-raml/healthcare_ehr2fhir_system_api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/ehr-fhir-system-api-2.0.1-raml/test-expected/healthcare_ehr2fhir_system_api.raml_outline.json"), "structureTest03", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=300.0f), @TimingTest(value=3000L, telemetryEvent=TelemetryType.PARSE, avgTime=300.0f), @TimingTest(value=5000L, telemetryEvent=TelemetryType.COMPLETION, avgTime=300.0f), @TimingTest(value=4000L, telemetryEvent=TelemetryType.REPORT, avgTime=300.0f)})
    public void suggestionTest04() {
        api.suggestionsTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/crm-fhir-system-api-2.0.1-raml/healthcare_sfhc2fhir_system_api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/crm-fhir-system-api-2.0.1-raml/test-expected/healthcare_sfhc2fhir_system_api.raml_suggestions.csv"), null, "suggestionTest04", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.STRUCTURE, avgTime=200.0f)})
    public void structureTest04() {
        api.structureTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/crm-fhir-system-api-2.0.1-raml/healthcare_sfhc2fhir_system_api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/crm-fhir-system-api-2.0.1-raml/test-expected/healthcare_sfhc2fhir_system_api.raml_outline.json"), "structureTest", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.PARSE, avgTime=200.0f), @TimingTest(value=5000L, telemetryEvent=TelemetryType.COMPLETION, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.REPORT, avgTime=200.0f)})
    public void suggestionTest05() {
        api.suggestionsTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/catalyst-retail-omnichannel-xp-api-2.0.3-raml/api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/catalyst-retail-omnichannel-xp-api-2.0.3-raml/test-expected/api.raml_suggestions.csv"), null, "suggestionTest05", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=5000L, count=10, avgTime=200.0f), @TimingTest(value=2000L, telemetryEvent=TelemetryType.STRUCTURE, avgTime=200.0f)})
    public void structureTest05() {
        api.structureTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/catalyst-retail-omnichannel-xp-api-2.0.3-raml/api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/catalyst-retail-omnichannel-xp-api-2.0.3-raml/test-expected/api.raml_outline.json"), "structureTest05", false);
    }
}

