/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.test.performance;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mule.alsp.test.performance.SimultaneousFileTestStrategy;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.params.TestParams;

class MultipliedTestStrategy
extends SimultaneousFileTestStrategy {
    private String testTimestamp;
    private String alias;

    MultipliedTestStrategy(TestApi api, String alias) {
        super(api);
        this.alias = alias;
        this.testTimestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    private URI cloneFile(URI uri) throws IOException {
        File tempDir = File.createTempFile(this.alias, this.testTimestamp);
        Path originalPath = new File(uri).getParentFile().toPath();
        Files.copy(originalPath, tempDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
        URI result = new File(tempDir, new File(uri).getName()).toURI();
        return result;
    }

    @Override
    public void test(SimultaneousFileTestStrategy.SimultaneousTestParams simulParams) {
        for (TestParams testParams : simulParams.testParamsList) {
            try {
                this.cloneFile(testParams.getUri());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        super.test(simulParams);
    }

    @Override
    public void cleanup(SimultaneousFileTestStrategy.SimultaneousTestParams simulParams) {
        super.cleanup(simulParams);
    }
}

