/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.test.performance;

import java.util.Arrays;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mule.alsp.telemetry.TelemetryType;
import org.mule.alsp.test.performance.SimultaneousFileTestStrategy;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.params.TestParams;
import org.mule.alsp.testapi.performance.PerformanceRunner;
import org.mule.alsp.testapi.performance.TimingTest;
import org.mule.alsp.testapi.performance.TimingTestValue;
import org.mule.alsp.testapi.performance.UsePerformanceRunnerConfiguration;
import org.mule.alsp.testapi.strategies.ManageDocumentStrategy;

@RunWith(value=PerformanceRunner.class)
@UsePerformanceRunnerConfiguration(threads=1)
@TimingTest(value=200L)
public class BasicPerformanceTest {
    private static TestApi api = null;
    private static String silent = System.getProperty("SILENT_ALS", "false");

    @BeforeClass
    public static void startup() {
        System.setProperty("SILENT_ALS", "false");
        api = new TestApi();
        api.warmup();
    }

    @AfterClass
    public static void cleanup() {
        System.setProperty("SILENT_ALS", silent);
    }

    @Before
    public void cleanCache() {
        ManageDocumentStrategy.getConcurrentactivitiesforfile().clear();
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=300L, count=10, avgTime=50.0f), @TimingTest(value=300L, telemetryEvent=TelemetryType.PARSE, avgTime=50.0f), @TimingTest(value=300L, telemetryEvent=TelemetryType.COMPLETION, avgTime=50.0f), @TimingTest(value=300L, telemetryEvent=TelemetryType.REPORT, avgTime=50.0f)})
    public void perfTest00() {
        this.test("body/test001.raml", "application/json:\n        ", "application/xml:\n        ", "xml:\n        ", "example:\n        ", "examples:\n        ", "enum:\n        - ", "default: ", "displayName: ", "description: ", "facets:\n        ", "type: ", "properties:\n        ", "items:\n        ");
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=300L, avgTime=50.0f, count=1), @TimingTest(value=300L, telemetryEvent=TelemetryType.COMPLETION, avgTime=50.0f)})
    public void simultaneousTest1() {
        SimultaneousFileTestStrategy strategy;
        SimultaneousFileTestStrategy simultaneousFileTestStrategy = strategy = new SimultaneousFileTestStrategy(api);
        simultaneousFileTestStrategy.getClass();
        SimultaneousFileTestStrategy.SimultaneousTestParams params = simultaneousFileTestStrategy.new SimultaneousFileTestStrategy.SimultaneousTestParams(new TestParams[0]);
        params.getTestParamsList().add(TestParams.createSuggestionTestParams(TestUtils.resolvedURI("suggestions/raml10/body/test001.raml"), null, Arrays.asList("application/json:\n        ", "application/xml:\n        ", "displayName: ", "type:\n        ", "enum:\n        - ", "xml:\n        ", "default: ", "description: ", "examples:\n        ", "example:\n        ", "facets:\n        ", "properties:\n        ", "items:\n        "), "simultaneousTest1", false));
        params.getTestParamsList().add(TestParams.createSuggestionTestParams(TestUtils.resolvedURI("suggestions/raml10/body/test002.raml"), null, Arrays.asList("application/json:\n        "), "simultaneousTest1", false));
        api.test(strategy, params);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=300L, avgTime=100.0f, count=10), @TimingTest(value=300L, telemetryEvent=TelemetryType.COMPLETION, avgTime=100.0f, name="mixedTest1_1"), @TimingTest(value=300L, telemetryEvent=TelemetryType.STRUCTURE, avgTime=100.0f, name="mixedTest1_2"), @TimingTest(value=300L, telemetryEvent=TelemetryType.ALSP_STRUCTURE, avgTime=100.0f, name="mixedTest1_2")})
    public void mixedTest1() {
        SimultaneousFileTestStrategy strategy;
        SimultaneousFileTestStrategy simultaneousFileTestStrategy = strategy = new SimultaneousFileTestStrategy(api);
        simultaneousFileTestStrategy.getClass();
        SimultaneousFileTestStrategy.SimultaneousTestParams params = simultaneousFileTestStrategy.new SimultaneousFileTestStrategy.SimultaneousTestParams(new TestParams[0]);
        params.getTestParamsList().add(TestParams.createSuggestionTestParams(TestUtils.resolvedURI("suggestions/raml10/body/test001.raml"), null, Arrays.asList("application/json:\n        ", "application/xml:\n        ", "displayName: ", "type:\n        ", "enum:\n        - ", "xml:\n        ", "default: ", "description: ", "examples:\n        ", "example:\n        ", "facets:\n        ", "properties:\n        ", "items:\n        "), "mixedTest1_1", false));
        params.getTestParamsList().add(TestParams.createStructureTestParams(TestUtils.resolvedURI("structure/RAML10/structure/test001/api.raml"), TestUtils.resolvedURI("structure/RAML10/structure/test001/api-outline.json"), "mixedTest1_2", false));
        api.test(strategy, params);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=500L, count=10, avgTime=50.0f), @TimingTest(value=200L, telemetryEvent=TelemetryType.PARSE, avgTime=50.0f), @TimingTest(value=500L, telemetryEvent=TelemetryType.COMPLETION, avgTime=50.0f), @TimingTest(value=800L, telemetryEvent=TelemetryType.REPORT, avgTime=50.0f)})
    public void bigApiNoIncludesTest01() {
        api.suggestionsTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/appian-api-1.0.5-raml/api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/appian-api-1.0.5-raml/test-expected/api.raml_suggestions.csv"), null, "bigApiNoIncludesTest00", false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=700L, count=10, avgTime=70.0f), @TimingTest(value=700L, telemetryEvent=TelemetryType.PARSE, avgTime=70.0f), @TimingTest(value=700L, telemetryEvent=TelemetryType.COMPLETION, avgTime=70.0f), @TimingTest(value=900L, telemetryEvent=TelemetryType.REPORT, avgTime=70.0f)})
    public void bigApiWithIncludesTest01() {
        api.suggestionsTest(TestUtils.resolvedURI("org/mule/alsp/test/publicapis/account-aggregation-process-api-2.0.0-raml/banking_accounts_process_api.raml"), TestUtils.resolvedURI("org/mule/alsp/test/publicapis/account-aggregation-process-api-2.0.0-raml/test-expected/banking_accounts_process_api.raml_suggestions.csv"), null, "bigApiWithIncludesTest01", false);
    }

    public void test(String uri, String ... proposals) {
        api.suggestionsTest(TestUtils.resolvedURI("suggestions/raml10/" + uri), null, Arrays.asList(proposals), uri, false);
    }
}

