/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.test.als.suggestions;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mule.alsp.telemetry.TelemetryType;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.performance.PerformanceRunner;
import org.mule.alsp.testapi.performance.TimingTest;
import org.mule.alsp.testapi.performance.TimingTestValue;
import org.mule.alsp.testapi.performance.UsePerformanceRunnerConfiguration;

@RunWith(value=PerformanceRunner.class)
@UsePerformanceRunnerConfiguration(threads=1)
public class RAML10CommonSuggestionsTest {
    protected static TestApi api = null;

    @BeforeClass
    public static void startup() throws URISyntaxException, IOException, InterruptedException {
        api = new TestApi();
    }

    @AfterClass
    public static void cleanup() {
        api.close();
    }

    private static void test(String uri, String ... proposals) {
        api.suggestionsTest(TestUtils.resolvedURI("suggestions/raml10/" + uri), null, Arrays.asList(proposals), null, false);
    }

    @Test
    @TimingTestValue(value={@TimingTest(value=266L, count=10, avgTime=110.0f), @TimingTest(value=100L, telemetryEvent=TelemetryType.PARSE)})
    public void test00() {
        RAML10CommonSuggestionsTest.test("body/test001.raml", "application/json:\n        ", "application/xml:\n        ", "xml:\n        ", "enum:\n        - ", "example:\n        ", "examples:\n        ", "default: ", "displayName: ", "description: ", "facets:\n        ", "type: ", "properties:\n        ", "items:\n        ");
    }

    @Ignore(value="Bug on ALS 3.2.4. It's already fixed on 3.2.5 - Still present in 4.1.1-1")
    @Test
    public void test01() {
        RAML10CommonSuggestionsTest.test("body/test002.raml", "application/json:\n        ");
    }

    @Test
    public void test02() {
        RAML10CommonSuggestionsTest.test("body/test003.raml", "xml:\n            ", "example:\n            ", "examples:\n            ", "enum:\n            - ", "default: ", "displayName: ", "description: ", "facets:\n            ", "type: ", "properties:\n            ", "items:\n            ", "application/json:\n            ", "application/xml:\n            ");
    }

    @Test
    public void test03() {
        RAML10CommonSuggestionsTest.test("body/test004.raml", "application/json:\n            ");
    }

    @Test
    public void test04() {
        RAML10CommonSuggestionsTest.test("body/test005.raml", "boolean", "integer", "datetime", "date-only", "datetime-only", "file", "any", "number", "string", "time-only", "nil", "array", "object", "A", "B");
    }

    @Test
    public void test05() {
        RAML10CommonSuggestionsTest.test("enums/test001.raml", "OAuth 1.0", "OAuth 2.0", "Basic Authentication", "Digest Authentication", "Pass Through", "x-");
    }

    @Test
    public void test06() {
        RAML10CommonSuggestionsTest.test("enums/test002.raml", "int32", "int64", "int", "long", "float", "double", "int16", "int8");
    }

    @Test
    public void test07() {
        RAML10CommonSuggestionsTest.test("examples/test01.raml", "valueSeven: ", "valueEight: ");
    }

    @Ignore(value="No previous reason - Still present in 4.1.1-1")
    @Test
    public void test08() {
        RAML10CommonSuggestionsTest.test("examples/test02.raml", "valueSeven", "valueEight");
    }

    @Test
    public void test09() {
        RAML10CommonSuggestionsTest.test("includeTag/test001.raml", "!include ");
    }

    @Test
    public void test15() {
        RAML10CommonSuggestionsTest.test("includes/testGroup01/test04.raml", "fragments/");
    }

    @Test
    public void test16() {
        RAML10CommonSuggestionsTest.test("includes/testGroup02/test01.raml", "test02.raml", "testFragment.raml", "testFragment2.raml");
    }

    @Test
    public void test17() {
        RAML10CommonSuggestionsTest.test("includes/testGroup02/test02.raml", "testFragment.raml");
    }

    @Test
    public void test18() {
        RAML10CommonSuggestionsTest.test("masterRef/testGroup01/test01.raml", "masters/testMaster.raml", "masters/testMaster2.raml");
    }

    @Test
    public void test20() {
        RAML10CommonSuggestionsTest.test("masterRef/testGroup01/test03.raml", "masters/testMaster.raml");
    }

    @Test
    public void test21() {
        RAML10CommonSuggestionsTest.test("masterRef/testGroup01/test04.raml", "masters/");
    }

    @Test
    public void test22() {
        RAML10CommonSuggestionsTest.test("masterRef/testGroup02/test01.raml", "test02.raml", "testMaster.raml", "testMaster2.raml");
    }

    @Test
    public void test23() {
        RAML10CommonSuggestionsTest.test("masterRef/testGroup02/test02.raml", "testMaster.raml");
    }

    @Test
    public void test26() {
        RAML10CommonSuggestionsTest.test("resourceTypeReferences/test003.raml", "resourceType1:\n      param1: $1\n      param2: $2", "resourceType2:\n      param1: $1\n      param2: $2");
    }

    @Test
    public void test27() {
        RAML10CommonSuggestionsTest.test("resourceTypeReferences/test006.raml", "resourceType1", "resourceType2");
    }

    @Ignore(value="Unignore when ALS-1857 is implemented")
    @Test
    public void test28() {
        RAML10CommonSuggestionsTest.test("resourceTypeReferences/test007.raml", "\n    resourceType1:\n      param1: $1\n      param2: $2", "resourceType2");
    }

    @Test
    public void test29() {
        RAML10CommonSuggestionsTest.test("traitReferences/test001.raml", "trait1", "trait2");
    }

    @Test
    public void test30() {
        RAML10CommonSuggestionsTest.test("traitReferences/test002.raml", "trait1", "trait2");
    }

    @Test
    public void test31() {
        RAML10CommonSuggestionsTest.test("traitReferences/test003.raml", "trait2");
    }

    @Test
    public void test32() {
        RAML10CommonSuggestionsTest.test("traitReferences/test004.raml", "trait1", "trait2");
    }

    @Test
    public void test41() {
        RAML10CommonSuggestionsTest.test("typeReferences/test001.raml", "stype2", "stype3", "string");
    }

    @Ignore(value="Bug W-13015775")
    @Test
    public void test42() {
        RAML10CommonSuggestionsTest.test("typeReferences/test002.raml", "stype2", "stype3", "string");
    }

    @Test
    public void test43() {
        RAML10CommonSuggestionsTest.test("typeReferences/test003.raml", "stype1", "stype2", "stype3", "string");
    }

    @Test
    public void test44() {
        RAML10CommonSuggestionsTest.test("typeReferences/test004.raml", "stype1", "stype2", "stype3", "string");
    }

    @Test
    public void test45() {
        RAML10CommonSuggestionsTest.test("typeReferences/test005.raml", "stype1", "stype2", "stype3", "string");
    }

    @Test
    public void test46() {
        RAML10CommonSuggestionsTest.test("typeReferences/test006.raml", "stype1", "stype2", "stype3", "string");
    }

    public void test47() {
        RAML10CommonSuggestionsTest.test("uses/testGroup01/test01.raml", "/testLib.raml", "/testLib2.raml");
    }

    public void test48() {
        RAML10CommonSuggestionsTest.test("uses/testGroup01/test02.raml", "/testLib.raml", "/testLib2.raml");
    }

    public void test49() {
        RAML10CommonSuggestionsTest.test("uses/testGroup01/test03.raml", "raml");
    }

    public void test50() {
        RAML10CommonSuggestionsTest.test("uses/testGroup01/test04.raml", "libraries");
    }

    public void test51() {
        RAML10CommonSuggestionsTest.test("uses/testGroup02/test01.raml", "test01.raml", "test02.raml", "testLib.raml", "testLib2.raml");
    }

    public void test52() {
        RAML10CommonSuggestionsTest.test("uses/testGroup02/test02.raml", "raml");
    }
}

