/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.test.als.suggestions;

import java.util.Arrays;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;

public class RAML08SuggestionsTest {
    private static TestApi api = null;

    @BeforeClass
    public static void startup() {
        api = new TestApi();
    }

    @AfterClass
    public static void cleanup() {
        api.close();
    }

    private static void test(String uri, String ... proposals) {
        api.suggestionsTest(TestUtils.resolvedURI("suggestions/raml08/" + uri), null, Arrays.asList(proposals), uri, false);
    }

    @Test
    public void test00() {
        RAML08SuggestionsTest.test("body/test001.raml", "application/json:\n        ", "application/xml:\n        ");
    }

    @Ignore(value="Bug on ALS 3.2.4. It's already fixed on 3.2.5 - Still present in 4.1.1-1")
    @Test
    public void test01() {
        RAML08SuggestionsTest.test("body/test002.raml", "application/json:\n        ");
    }

    @Test
    public void test02() {
        RAML08SuggestionsTest.test("body/test003.raml", "application/json:\n            ", "application/xml:\n            ");
    }

    @Test
    public void test03() {
        RAML08SuggestionsTest.test("body/test004.raml", "application/json:\n            ");
    }

    @Test
    public void test04() {
        RAML08SuggestionsTest.test("enums/test001.raml", "Basic Authentication", "OAuth 1.0", "OAuth 2.0", "Digest Authentication", "x-");
    }

    @Test
    public void test05() {
        RAML08SuggestionsTest.test("includeTag/test001.raml", "!include ");
    }

    @Test
    public void test06() {
        RAML08SuggestionsTest.test("includeTag/test002.raml", "!include ");
    }

    @Test
    public void test07() {
        RAML08SuggestionsTest.test("includeTag/test004.raml", "!include ");
    }

    @Test
    public void test08() {
        RAML08SuggestionsTest.test("structure/test01.raml", "responses:\n      ");
    }

    @Test
    public void test09() {
        RAML08SuggestionsTest.test("structure/test03.raml", "resourceTypes:\n  ");
    }

    @Test
    public void test10() {
        RAML08SuggestionsTest.test("structure/test04.raml", "title: ");
    }

    @Test
    public void test11() {
        RAML08SuggestionsTest.test("structure/test05.raml", "traits:\n  ");
    }

    @Test
    public void test12() {
        RAML08SuggestionsTest.test("structure/test07.raml", "documentation:\n  - ", "documentation:\n  -\n    content: $1\n    title: $2");
    }

    @Test
    public void test13() {
        RAML08SuggestionsTest.test("structure/test08.raml", "version: ");
    }

    @Test
    public void test14() {
        RAML08SuggestionsTest.test("structure/test09.raml", "baseUri: ", "baseUriParameters:\n  ");
    }

    @Test
    public void test15() {
        RAML08SuggestionsTest.test("structure/test10.raml", "protocols:\n  - ");
    }

    @Test
    public void test16() {
        RAML08SuggestionsTest.test("structure/test11.raml", "mediaType: ");
    }

    @Test
    public void test17() {
        RAML08SuggestionsTest.test("structure/test12.raml", "schemas:\n  ");
    }

    @Test
    public void test18() {
        RAML08SuggestionsTest.test("structure/test13.raml", "securitySchemes:\n  ");
    }

    @Test
    public void test19() {
        RAML08SuggestionsTest.test("structure/test14.raml", "securedBy:\n  - ");
    }

    @Test
    public void test20() {
        RAML08SuggestionsTest.test("structure/test18.raml", "body:\n      ");
    }

    @Test
    public void test21() {
        RAML08SuggestionsTest.test("structure/test21.raml", "is:\n    - ");
    }

    @Test
    public void test22() {
        RAML08SuggestionsTest.test("structure/test22.raml", "type:\n    ");
    }

    @Test
    public void test23() {
        RAML08SuggestionsTest.test("structure/test23.raml", "description: ");
    }

    @Test
    public void test24() {
        RAML08SuggestionsTest.test("structure/test24.raml", "displayName: ");
    }

    @Test
    public void test25() {
        RAML08SuggestionsTest.test("structure/test27.raml", "uriParameters:\n    ");
    }

    @Test
    public void test26() {
        RAML08SuggestionsTest.test("structure/test28.raml", "options:\n    ");
    }

    @Test
    public void test27() {
        RAML08SuggestionsTest.test("structure/test29.raml", "head:\n    ");
    }

    @Test
    public void test30() {
        RAML08SuggestionsTest.test("structure/test26.raml", "put:\n    ", "post:\n    ", "patch:\n    ");
    }

    @Test
    public void test31() {
        RAML08SuggestionsTest.test("structure/test32.raml", "queryParameters:\n      ");
    }

    @Test
    public void test32() {
        RAML08SuggestionsTest.test("structure/test33.raml", "headers:\n      ");
    }

    @Test
    public void test33() {
        RAML08SuggestionsTest.test("structure/test34.raml", "description: ");
    }

    @Test
    public void test34() {
        RAML08SuggestionsTest.test("structure/test35.raml", "responses:\n      ");
    }

    @Test
    public void test35() {
        RAML08SuggestionsTest.test("structure/test37.raml", "is:\n      - ");
    }

    @Test
    public void test36() {
        RAML08SuggestionsTest.test("structure/test38.raml", "description: ");
    }

    @Test
    public void test37() {
        RAML08SuggestionsTest.test("structure/test41.raml", "headers:\n          ");
    }

    @Test
    public void test38() {
        RAML08SuggestionsTest.test("structure/test42.raml", "body:\n          ");
    }

    @Test
    public void test39() {
        RAML08SuggestionsTest.test("structure/test44.raml", "is:\n        - ");
    }

    @Ignore(value="Bug W-13014853")
    @Test
    public void test40() {
        RAML08SuggestionsTest.test("structure/test45.raml", "type:\n        ");
    }

    @Test
    public void test41() {
        RAML08SuggestionsTest.test("structure/test46.raml", "description: ");
    }

    @Test
    public void test42() {
        RAML08SuggestionsTest.test("structure/test47.raml", "displayName: ");
    }

    @Ignore(value="Bug W-13014853")
    @Test
    public void test43() {
        RAML08SuggestionsTest.test("structure/test49.raml", "put:\n        ", "post:\n        ", "patch:\n        ");
    }

    @Ignore(value="Bug W-13014853")
    @Test
    public void test44() {
        RAML08SuggestionsTest.test("structure/test50.raml", "uriParameters:\n        ");
    }

    @Ignore(value="Bug W-13014853")
    @Test
    public void test45() {
        RAML08SuggestionsTest.test("structure/test51.raml", "options:\n        ");
    }

    @Ignore(value="Bug W-13014853")
    @Test
    public void test46() {
        RAML08SuggestionsTest.test("structure/test52.raml", "head:\n        ");
    }

    @Test
    public void test49() {
        RAML08SuggestionsTest.test("structure/test55.raml", "usage: ");
    }

    @Ignore(value="Bug W-13014853")
    @Test
    public void test50() {
        RAML08SuggestionsTest.test("structure/test57.raml", "queryParameters:\n        ");
    }

    @Ignore(value="Bug W-13014853")
    @Test
    public void test51() {
        RAML08SuggestionsTest.test("structure/test58.raml", "headers:\n        ");
    }

    @Ignore(value="Bug W-13014853")
    @Test
    public void test52() {
        RAML08SuggestionsTest.test("structure/test60.raml", "responses:\n        ");
    }

    @Test
    public void test53() {
        RAML08SuggestionsTest.test("structure/test63.raml", "description: ");
    }

    @Test
    public void test54() {
        RAML08SuggestionsTest.test("structure/test64.raml", "displayName: ");
    }

    @Ignore(value="Bug W-13014853")
    @Test
    public void test55() {
        RAML08SuggestionsTest.test("structure/test69.raml", "body:\n        ");
    }

    @Test
    public void test56() {
        RAML08SuggestionsTest.test("structure/test83.raml", "type: ");
    }

    @Test
    public void test57() {
        RAML08SuggestionsTest.test("structure/test84.raml", "settings:\n      ");
    }

    @Test
    public void test58() {
        RAML08SuggestionsTest.test("structure/test86.raml", "accessTokenUri: ");
    }

    @Test
    public void test59() {
        RAML08SuggestionsTest.test("structure/test89.raml", "description: ");
    }

    @Test
    public void test60() {
        RAML08SuggestionsTest.test("structure/test91.raml", "headers:\n        ");
    }

    @Test
    public void test61() {
        RAML08SuggestionsTest.test("structure/test93.raml", "responses:\n        ");
    }

    @Test
    public void test62() {
        RAML08SuggestionsTest.test("structure/test94.raml", "requestTokenUri: ");
    }

    @Test
    public void test63() {
        RAML08SuggestionsTest.test("structure/test96.raml", "tokenCredentialsUri: ");
    }

    @Test
    public void test64() {
        RAML08SuggestionsTest.test("methods/test01.raml", "displayName: ", "type:\n    ", "description: ", "get:\n    ", "put:\n    ", "post:\n    ", "delete:\n    ", "options:\n    ", "head:\n    ", "patch:\n    ", "securedBy:\n    - ", "is:\n    - ", "uriParameters:\n    ");
    }

    @Test
    public void test65() {
        RAML08SuggestionsTest.test("methods/test02.raml", "displayName: ", "type:\n    ", "description: ", "get:\n    ", "put:\n    ", "post:\n    ", "delete:\n    ", "options:\n    ", "head:\n    ", "patch:\n    ", "securedBy:\n    - ", "is:\n    - ", "uriParameters:\n    ");
    }
}

