/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.test.als.suggestions;

import java.util.Arrays;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;

public class OAS20StructureSuggestionsTest {
    private static TestApi api = null;

    @BeforeClass
    public static void startup() {
        api = new TestApi();
    }

    @AfterClass
    public static void cleanup() {
        api.close();
    }

    private static void test(String uri, String ... proposals) {
        api.suggestionsTest(TestUtils.resolvedURI("suggestions/oas20/" + uri), null, Arrays.asList(proposals), uri, false);
    }

    @Test
    public void test0() {
        OAS20StructureSuggestionsTest.test("structure_json/test01.json", "\"info\": {\n  \t\"$1\"\n  },", "\"info\": {\n  \t\"title\": \"$1\",\n  \t\"version\": \"$2\"\n  },");
    }

    @Test
    public void test1() {
        OAS20StructureSuggestionsTest.test("structure_json/test08.json", "\"definitions\": {\n  \t\"$1\"\n  },");
    }

    @Test
    public void test2() {
        OAS20StructureSuggestionsTest.test("structure_json/test10.json", "\"responses\": {\n  \t\"$1\"\n  },");
    }

    @Test
    public void test3() {
        OAS20StructureSuggestionsTest.test("structure_json/test11.json", "\"securityDefinitions\": {\n  \t\"$1\"\n  },");
    }

    @Test
    public void test4() {
        OAS20StructureSuggestionsTest.test("structure_json/test14.json", "\"externalDocs\": {\n  \t\"$1\"\n  },", "\"externalDocs\": {\n  \t\"url\": \"$1\"\n  },");
    }

    @Test
    public void test5() {
        OAS20StructureSuggestionsTest.test("structure_json/test16.json", "\"version\": \"$1\",");
    }

    @Test
    public void test6() {
        OAS20StructureSuggestionsTest.test("structure_json/test20.json", "\"contact\": {\n    \t\"$1\"\n    },");
    }

    @Test
    public void test7() {
        OAS20StructureSuggestionsTest.test("structure_json/test34.json", "\"summary\": \"$1\",");
    }

    @Test
    public void test9() {
        OAS20StructureSuggestionsTest.test("structure_json/test36.json", "\"externalDocs\": {\n        \t\"$1\"\n        },");
    }

    @Test
    public void test11() {
        OAS20StructureSuggestionsTest.test("structure_json/test41.json", "\"responses\": {\n        \t\"$1\"\n        }");
    }

    @Test
    public void test12() {
        OAS20StructureSuggestionsTest.test("structure_json/test43.json", "\"deprecated\": $1,");
    }

    @Test
    public void test13() {
        OAS20StructureSuggestionsTest.test("structure_json/test44.json", "\"security\": [\n        \t\"$1\"\n        ],");
    }

    @Test
    public void test14() {
        OAS20StructureSuggestionsTest.test("structure_json/test47.json", "\"description\": \"$1\",");
    }

    @Test
    public void test15() {
        OAS20StructureSuggestionsTest.test("structure_json/test48.json", "\"schema\": {\n            \t\"$1\"\n            },", "\"schema\": {\n            \t\"description\": \"$1\",\n            \t\"type\": \"$2\"\n            },");
    }

    @Test
    public void test19() {
        OAS20StructureSuggestionsTest.test("structure_json/test61.json", "\"exclusiveMaximum\": $1,");
    }

    @Test
    public void test21() {
        OAS20StructureSuggestionsTest.test("structure_json/test63.json", "\"exclusiveMinimum\": $1,");
    }

    @Test
    public void test23() {
        OAS20StructureSuggestionsTest.test("structure_json/test66.json", "\"pattern\": \"$1\",");
    }

    @Test
    public void test24() {
        OAS20StructureSuggestionsTest.test("structure_json/test67.json", "\"maxItems\": $1,");
    }

    @Test
    public void test25() {
        OAS20StructureSuggestionsTest.test("structure_json/test68.json", "\"minItems\": $1,");
    }

    @Ignore(value="Bug W-13012261")
    @Test
    public void test26() {
        OAS20StructureSuggestionsTest.test("structure_json/test72.json", "\"example\": \"$1\",");
    }

    @Test
    public void test27() {
        OAS20StructureSuggestionsTest.test("structure_json/test73.json", "\"items\": {\n          \t\"$1\"\n          },");
    }

    @Test
    public void test28() {
        OAS20StructureSuggestionsTest.test("structure_json/test74.json", "\"collectionFormat\": \"$1\",");
    }

    @Test
    public void test29() {
        OAS20StructureSuggestionsTest.test("structure_json/test75.json", "\"title\": \"$1\",");
    }

    @Test
    public void test30() {
        OAS20StructureSuggestionsTest.test("structure_json/test76.json", "\"description\": \"$1\",");
    }

    @Test
    public void test31() {
        OAS20StructureSuggestionsTest.test("structure_json/test77.json", "\"properties\": {\n      \t\"$1\"\n      },");
    }

    @Test
    public void test32() {
        OAS20StructureSuggestionsTest.test("structure_json/test78.json", "\"discriminator\": \"$1\",");
    }

    @Test
    public void test33() {
        OAS20StructureSuggestionsTest.test("structure_json/test85.json", "\"readOnly\": $1,");
    }

    @Ignore(value="Bug W-13012261")
    @Test
    public void test34() {
        OAS20StructureSuggestionsTest.test("structure_json/test88.json", "\"description\": \"$1\",");
    }

    @Test
    public void test35() {
        OAS20StructureSuggestionsTest.test("structure_json/test89.json", "\"externalDocs\": {\n      \t\"$1\"\n      }");
    }

    @Ignore(value="Bug W-13012261")
    @Test
    public void test36() {
        OAS20StructureSuggestionsTest.test("structure_json/test104.json", "\"namespace\": \"$1\",");
    }

    @Test
    public void test37() {
        OAS20StructureSuggestionsTest.test("structure_json/test105.json", "\"prefix\": \"$1\"");
    }

    @Test
    public void test38() {
        OAS20StructureSuggestionsTest.test("structure_json/test105.json", "\"prefix\": \"$1\"");
    }

    @Ignore(value="Bug in 4.1.1-1 - https://www.mulesoft.org/jira/browse/ALS-1831")
    @Test
    public void test39() {
        OAS20StructureSuggestionsTest.test("structure/test01.yml", "info:\n  ", "info:\n  title: $1\n  version: $2");
    }

    @Ignore(value="Bug in 4.1.1-1 - https://www.mulesoft.org/jira/browse/ALS-1831")
    @Test
    public void test40() {
        OAS20StructureSuggestionsTest.test("structure/test07.yml", "paths:\n  ");
    }

    @Test
    public void test41() {
        OAS20StructureSuggestionsTest.test("structure/test10.yml", "responses:\n  ");
    }

    @Test
    public void test42() {
        OAS20StructureSuggestionsTest.test("structure/test15.yml", "title: ");
    }

    @Test
    public void test43() {
        OAS20StructureSuggestionsTest.test("structure/test16.yml", "version: ");
    }

    @Test
    public void test44() {
        OAS20StructureSuggestionsTest.test("structure/test17.yml", "description: ");
    }

    @Test
    public void test45() {
        OAS20StructureSuggestionsTest.test("structure/test20.yml", "contact:\n    ");
    }

    @Test
    public void test46() {
        OAS20StructureSuggestionsTest.test("structure/test21.yml", "name: ");
    }

    @Test
    public void test47() {
        OAS20StructureSuggestionsTest.test("structure/test22.yml", "url: ");
    }

    @Test
    public void test48() {
        OAS20StructureSuggestionsTest.test("structure/test23.yml", "name: ");
    }

    @Test
    public void test49() {
        OAS20StructureSuggestionsTest.test("structure/test24.yml", "url: ");
    }

    @Test
    public void test50() {
        OAS20StructureSuggestionsTest.test("structure/test25.yml", "email: ");
    }

    @Test
    public void test51() {
        OAS20StructureSuggestionsTest.test("structure/test26.yml", "url: ");
    }

    @Test
    public void test52() {
        OAS20StructureSuggestionsTest.test("structure/test27.yml", "description: ");
    }

    @Test
    public void test53() {
        OAS20StructureSuggestionsTest.test("structure/test29.yml", "put:\n      ", "post:\n      ", "patch:\n      ", "put:\n      responses:\n        $1: ", "put:\n      responses:\n        $1:\n          description: $2", "post:\n      responses:\n        $1: ", "post:\n      responses:\n        $1:\n          description: $2", "patch:\n      responses:\n        $1: ", "patch:\n      responses:\n        $1:\n          description: $2");
    }

    @Test
    public void test54() {
        OAS20StructureSuggestionsTest.test("structure/test33.yml", "parameters:\n        - ");
    }

    @Test
    public void test55() {
        OAS20StructureSuggestionsTest.test("structure/test34.yml", "summary: ");
    }

    @Test
    public void test56() {
        OAS20StructureSuggestionsTest.test("structure/test35.yml", "description: ");
    }

    @Test
    public void test57() {
        OAS20StructureSuggestionsTest.test("structure/test37.yml", "operationId: ");
    }

    @Test
    public void test58() {
        OAS20StructureSuggestionsTest.test("structure/test43.yml", "deprecated: ");
    }

    @Test
    public void test59() {
        OAS20StructureSuggestionsTest.test("structure/test44.yml", "security:\n        - ", "security:\n        -\n          type: $1");
    }

    @Test
    public void test60() {
        OAS20StructureSuggestionsTest.test("structure/test47.yml", "description: ");
    }

    @Test
    public void test61() {
        OAS20StructureSuggestionsTest.test("structure/test48.yml", "schema:\n            ", "schema:\n            description: $1\n            type: $2");
    }

    @Ignore(value="Bug on ALS 3.2.4 https://www.mulesoft.org/jira/browse/ALS-1438 - Still present in 4.1.1-1")
    @Test
    public void test62() {
        OAS20StructureSuggestionsTest.test("structure/test52.yml", "description: ");
    }

    @Ignore(value="Bug on ALS 3.2.4 https://www.mulesoft.org/jira/browse/ALS-1437 - Still present in 4.1.1-1")
    @Test
    public void test63() {
        OAS20StructureSuggestionsTest.test("structure/test56.yml", "schema:\n            ");
    }

    @Test
    public void test64() {
        OAS20StructureSuggestionsTest.test("structure/test58.yml", "format: ");
    }

    @Test
    public void test65() {
        OAS20StructureSuggestionsTest.test("structure/test59.yml", "default: ");
    }

    @Ignore(value="Bug on ALS 3.2.4 https://www.mulesoft.org/jira/browse/ALS-1438 - Still present in 4.1.1-1")
    @Test
    public void test66() {
        OAS20StructureSuggestionsTest.test("structure/test60.yml", "maximum: ");
    }

    @Ignore(value="Bug on ALS 3.2.4 https://www.mulesoft.org/jira/browse/ALS-1438 - Still present in 4.1.1-1")
    @Test
    public void test67() {
        OAS20StructureSuggestionsTest.test("structure/test62.yml", "minimum: ");
    }

    @Test
    public void test68() {
        OAS20StructureSuggestionsTest.test("structure/test66.yml", "pattern: ");
    }

    @Ignore(value="Bug on ALS 3.2.4 https://www.mulesoft.org/jira/browse/ALS-1438 - Still present in 4.1.1-1")
    @Test
    public void test69() {
        OAS20StructureSuggestionsTest.test("structure/test71.yml", "multipleOf: ");
    }

    @Test
    public void test70() {
        OAS20StructureSuggestionsTest.test("structure/test72.yml", "example: ");
    }

    @Ignore(value="Bug on ALS 3.2.4 https://www.mulesoft.org/jira/browse/ALS-1438 - Still present in 4.1.1-1")
    @Test
    public void test71() {
        OAS20StructureSuggestionsTest.test("structure/test73.yml", "items:\n          ");
    }

    @Test
    public void test72() {
        OAS20StructureSuggestionsTest.test("structure/test75.yml", "title: ");
    }

    @Test
    public void test73() {
        OAS20StructureSuggestionsTest.test("structure/test76.yml", "description: ");
    }

    @Test
    public void test74() {
        OAS20StructureSuggestionsTest.test("structure/test77.yml", "properties:\n      ");
    }

    @Test
    public void test75() {
        OAS20StructureSuggestionsTest.test("structure/test78.yml", "discriminator: ");
    }

    @Test
    public void test76() {
        OAS20StructureSuggestionsTest.test("structure/test79.yml", "xml:\n      ");
    }
}

